/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           FontProvider.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "FontProvider.h"
#endif

#include "FontProvider.h"

#include <wx/font.h>
#include <wx/gdicmn.h>
#include <wx/log.h>
#include <wx/tokenzr.h>

//#include "func.h"
#include "Conf.h"

extern Config *config;

wxFont *FontProvider::fontDefault = 0;
wxFont *FontProvider::fontHeader = 0;
wxFont *FontProvider::fontGraphic = 0;
wxFont *FontProvider::fontText = 0;
wxFont *FontProvider::fontSymbol = 0;


/**************************************************************
***
**   FontProvider   ---   makeFontsDirty
***
***************************************************************/
void FontProvider::makeFontsDirty()
{
	fontDefault = fontGraphic = fontText = fontHeader = fontSymbol = 0;
}

/**************************************************************
***
**   FontProvider   ---   initFont
***
***************************************************************/
wxFont *FontProvider::initFont( const wxString cf, const int f  )
{
	wxString sPointSize, sFamily, sStyle, sWeight, sUnderline, sFacename;
	long pointSize, family, style, weight;
	bool underline = false;
	pointSize = family = style = weight = 0;
	wxStringTokenizer t( cf, wxT( ":" ));

	sPointSize = t.GetNextToken();
	sFamily = t.GetNextToken();
	sStyle = t.GetNextToken();
	sWeight = t.GetNextToken();
	sUnderline = t.GetNextToken();
	sFacename = t.GetNextToken();
	if ( sPointSize.IsEmpty() || sFamily.IsEmpty() || sStyle.IsEmpty() || sWeight.IsEmpty()
		|| sUnderline.IsEmpty() || sFacename.IsEmpty())
	{
		return getFallbackFont( f );
	}
	else
	{
		sPointSize.ToLong( &pointSize );
		sFamily.ToLong( &family );
		sStyle.ToLong( &style );
		sWeight.ToLong( &weight );
		if ( sUnderline.CmpNoCase( wxT( "true" )) == 0 ) underline = true;
		return wxTheFontList->FindOrCreateFont( (int)pointSize, (int)family, (int)style, (int)weight, underline, sFacename );
	}
}

/**************************************************************
***
**   FontProvider   ---   writeConfigEntry
***
***************************************************************/
wxFont *FontProvider::getFallbackFont( const int f )
{
	const int size = 10;
	switch( f ) 
	{
		case FONT_DEFAULT:
			return wxTheFontList->FindOrCreateFont( size, wxDEFAULT, wxNORMAL, wxNORMAL );
		break;
		case FONT_TEXT:
			return wxTheFontList->FindOrCreateFont( size, wxMODERN, wxNORMAL, wxNORMAL );
		break;
		case FONT_HEADER:
			return wxTheFontList->FindOrCreateFont( size, wxDEFAULT, wxNORMAL, wxBOLD );
		break;
		case FONT_GRAPHIC:
			return wxTheFontList->FindOrCreateFont( size, wxSWISS, wxNORMAL, wxNORMAL );
		break;
		case FONT_SYMBOL:
			//return wxTheFontList->FindOrCreateFont( size, wxDEFAULT, wxNORMAL, wxNORMAL, false, DEFAULT_SYMBOLFONTNAME );
			return wxTheFontList->FindOrCreateFont( size, wxSWISS, wxNORMAL, wxNORMAL );
		break;
		default:
			wxLogError( wxT(  "ERROR: falling back to default font, id beeing  %d" ), f  );
			return wxTheFontList->FindOrCreateFont( size, wxSWISS, wxNORMAL, wxNORMAL );
		break;
	}
}

/**************************************************************
***
**   FontProvider   ---   getConfigEntry
***
***************************************************************/
wxString FontProvider::getConfigEntry( const wxFont &font )
{
	wxString s;
	s.sprintf( wxT( "%d:%d:%d:%d:%s:%s" ), font.GetPointSize(), font.GetFamily(),
		font.GetStyle(), font.GetWeight(),
		( font.GetUnderlined() ? wxT( "true" ) : wxT( "false" )),
		font.GetFaceName().c_str() );
	return s;
}

/**************************************************************
***
**   FontProvider   ---   getFont
***
***************************************************************/
wxFont *FontProvider::getFont( const int f )
{
	switch( f )
	{
		case FONT_DEFAULT:
			if ( ! fontDefault ) fontDefault = initFont( config->fontDefault, f );
			if ( config->fontDefault.IsEmpty()) config->fontDefault = getConfigEntry( *fontDefault );
			return fontDefault;
		break;
		case FONT_TEXT:
			if ( ! fontText ) fontText = initFont( config->fontText, f );
			if ( config->fontText.IsEmpty()) config->fontText = getConfigEntry( *fontText );
			return fontText;
		break;
		case FONT_HEADER:
			if ( ! fontHeader ) fontHeader = initFont( config->fontHeader, f );
			if ( config->fontHeader.IsEmpty()) config->fontHeader = getConfigEntry( *fontHeader );
			return fontHeader;
		break;
		case FONT_GRAPHIC:
			if ( ! fontGraphic ) fontGraphic = initFont( config->fontGraphic, f );
			if ( config->fontGraphic.IsEmpty()) config->fontGraphic = getConfigEntry( *fontGraphic );
			return fontGraphic;
		break;
		case FONT_SYMBOL:
			if ( ! fontSymbol ) fontSymbol = initFont( config->fontSymbol, f );
			if ( config->fontSymbol.IsEmpty()) config->fontSymbol = getConfigEntry( *fontSymbol );
			return fontSymbol;
		break;
		default:
			wxLogError( wxT(  "Warning: invalid font %d returning default" ), f );
			if ( ! fontDefault ) fontDefault = initFont( config->fontDefault, f );
			if ( config->fontDefault.IsEmpty()) config->fontDefault = getConfigEntry( *fontDefault );
			return fontDefault;
		break;
	}
}

