/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           FontProvider.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _FONTPROVIDER_H_
#define _FONTPROVIDER_H_

#ifdef __GNUG__
	#pragma interface "FontProvider.h"
#endif

#include <wx/object.h>
#include <wx/string.h>

class wxFont;

enum { FONT_DEFAULT = 0, FONT_HEADER, FONT_TEXT, FONT_GRAPHIC, FONT_SYMBOL };

/*****************************************************
**
**   CLASS FontProvider  
**
******************************************************/
class FontProvider : public wxObject
{
public:
	wxFont *getDefaultFont() { return getFont( FONT_DEFAULT ); }
	wxFont *getHeaderFont() { return getFont( FONT_HEADER ); }
	wxFont *getTextFont() { return getFont( FONT_TEXT ); }
	wxFont *getGraphicFont() { return getFont( FONT_GRAPHIC ); }
	wxFont *getSymbolFont() { return getFont( FONT_SYMBOL ); }
	void makeFontsDirty();
	wxString getConfigEntry( const wxFont& );
	wxFont *initFont( const wxString cf, const int = FONT_DEFAULT );

private:
	wxFont *getFont( const int );
	wxFont *getFallbackFont( const int f );
	static wxFont *fontDefault, *fontHeader, *fontGraphic, *fontText, *fontSymbol;

};

#endif


