/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           GenericDasa.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _GENERICDASA_H_
#define _GENERICDASA_H_

#ifdef __GNUG__
	#pragma interface "GenericDasa.h"
#endif

#include "constants.h"
#include "Dasa.h"

class Horoscope;

/*****************************************************
**
**   CLASS GenericNakshatraDasaExpert  
**
******************************************************/
class GenericNakshatraDasaExpert : public GrahaDasaExpert
{
public:

	virtual vector<Dasa*> getFirstLevel( Horoscope*, const int varga = 0 );
	virtual vector<Dasa*> getNextLevel( Dasa* );
	virtual const wxChar *getName() = 0;

	virtual bool hasKpFeatures() { return true; }
	virtual void getKPLord( const double &len, int &lord, int &sublord );
  virtual vector<KPEvent> getKPEventList( const double &startlen, const double &Endlen, const double &startjd );

protected:
	virtual double getPortion( Horoscope *h, int &nak );
	virtual int getNbLords() = 0;
	virtual int getTotalLength() = 0;
	virtual int getDasaLordByIndex( const int& ) = 0;
	virtual int getDasaIndex4Nakshatra( const int& ) = 0;
	virtual int getDasaDuration( const int& ) = 0;
	virtual const wxChar *getExtraText( const int& ) { return 0; }
};

/*****************************************************
**
**   CLASS YoginiDasaExpert  
**
******************************************************/
class YoginiDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Yogini" ); }

protected:
	virtual int getNbLords() { return 8; }
	virtual int getTotalLength() { return 36; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
	virtual const wxChar *getExtraText( const int& );
};

/*****************************************************
**
**   CLASS ShodshottariDasaExpert  
**
******************************************************/
class ShodshottariDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Shodshottari" ); }

protected:
	virtual int getNbLords() { return 8; }
	virtual int getTotalLength() { return 116; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
};

/*****************************************************
**
**   CLASS DvadashottariDasaExpert  
**
******************************************************/
class DvadashottariDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Dvadashottari" ); }

protected:
	virtual int getNbLords() { return 8; }
	virtual int getTotalLength() { return 112; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
};

/*****************************************************
**
**   CLASS PanchottariDasaExpert  
**
******************************************************/
class PanchottariDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Panchottari" ); }

protected:
	virtual int getNbLords() { return 7; }
	virtual int getTotalLength() { return 105; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
};

/*****************************************************
**
**   CLASS ShatabdikaDasaExpert  
**
******************************************************/
class ShatabdikaDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Shatabdika" ); }

protected:
	virtual int getNbLords() { return 7; }
	virtual int getTotalLength() { return 100; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
};

/*****************************************************
**
**   CLASS ChaturashitiSamaDasaExpert  
**
******************************************************/
class ChaturashitiSamaDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Chaturashiti Sama" ); }

protected:
	virtual int getNbLords() { return 7; }
	virtual int getTotalLength() { return 84; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
};

/*****************************************************
**
**   CLASS DvisaptatiSamaDasaExpert  
**
******************************************************/
class DvisaptatiSamaDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Dvisaptati Sama" ); }

protected:
	virtual int getNbLords() { return 8; }
	virtual int getTotalLength() { return 72; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
};

/*****************************************************
**
**   CLASS ShatTrimshatSamaDasaExpert  
**
******************************************************/
class ShatTrimshatSamaDasaExpert : public GenericNakshatraDasaExpert
{
public:

	virtual const wxChar *getName() { return _( "Shat Trimsat Sama" ); }

protected:
	virtual int getNbLords() { return 8; }
	virtual int getTotalLength() { return 36; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );
};



#endif

