/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Horoscope.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _HOROSCOPE_H_
#define _HOROSCOPE_H_

#ifdef __GNUG__
	#pragma interface "Horoscope.h"
#endif

#include "constants.h"
#include "DataSet.h"
#include "SimpleHoroscope.h"

#include <vector>

class Calculator;
class IPlanet;
class CalcualtorSwe;
class Varga;
class Writer;

using namespace std;

/*****************************************************
**
**   CLASS Horoscope  
**
******************************************************/
class Horoscope : public SimpleHoroscope
{
public:

	Horoscope();
	virtual ~Horoscope();
	void update();
	IPlanet *getIPlanet( const int &i );
	double getSunrise() { return sunrise; }
	double getSunset() { return sunset; }
	int getAvastha( const int &planet, const int whichAvastha = 0 );
	void updateKP( const int &dasaindex );
	int getKPLord( const int &planet, const bool &sublord );
	bool getDayBirth() { return isDayBirth; }
	virtual double getObjectLength( const int& );
	Varga *getVarga( const int &planet, const int &varga );

	// deprecated
	void dumpAvasthas( wxString& );

	// writer methods
	void writeWesternPlanets( Writer* );
	void writeVedicPlanets( Writer* );
	void writeKp( Writer*, const int &dasaindex );
	void writeAspects( Writer* );

protected:
	int kp_lord[MAX_IOBJECTS_LAGNA_UPA_BHAVA];
	int kp_sublord[MAX_IOBJECTS_LAGNA_UPA_BHAVA];
	void updateAvasthas();

	vector<IPlanet*> iplanets;
	int sayanadiAvastha[9];
	double sunrise, sunset;
	bool isDayBirth;

	double lagna_len[NUM_LAGNA];
	double upagraha_len[NUM_UPA];
	Varga *varga[MAX_IOBJECTS_LAGNA_UPA][NB_VARGAS];
};

/*****************************************************
**
**   CLASS TajakaHoroscope  
**
******************************************************/
class TajakaHoroscope : public Horoscope
{
public:
	TajakaHoroscope( DataSet* );
	void calcTajaka( const int &year, const bool &vedic );
	void dump( wxString &o, const bool &vedic );

private:
	DataSet *birth_ds;
};

/*****************************************************
**
**   CLASS CompositHoroscope  
**
******************************************************/
class CompositHoroscope : public Horoscope
{
public:
	CompositHoroscope();
	void update( Horoscope*, Horoscope* );

	virtual bool isObjectRetrograde( const int& ) { return false; }
	void dump( wxString &o, const bool vedic );

private:

};

#endif



