/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           HtmlWriter.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "HtmlWriter.h"
#endif

#include "HtmlWriter.h"

#include "Conf.h"
#include "func.h"
#include "ColorProvider.h"
#include "FontProvider.h"
  
#include <wx/font.h>
  
extern Config *config;

/*****************************************************
**
**   HtmlWriter   ---   Constructor
**
******************************************************/
HtmlWriter::HtmlWriter()
{
	FontProvider f;

	headerFont = f.getHeaderFont();
	textFont = f.getTextFont();
	ColorProvider cp;
	cp.getRgbString( bgcolor, COLOR_BG );
	cp.getRgbString( bgcolor2, COLOR_BG2 );
	cp.getRgbString( fgcolor, COLOR_FG );
	type = WRITER_HTML;
}

/*****************************************************
**
**   HtmlWriter   ---   beginWriting
**
******************************************************/
void HtmlWriter::beginWriting()
{
	s = wxT( "" );
  s << wxT( "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//en\">" ) << Endl;
  s << wxT( "<html>" ) << Endl;
  s << wxT( "<head>" ) << Endl;
  s << wxT( "</head>" ) << Endl;
  s << wxT( "<body " );
  s << wxT( " bgcolor=" ) << bgcolor;
  s << wxT( " text=" ) << fgcolor;
  s << wxT( ">" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---   endWriting
**
******************************************************/
void HtmlWriter::endWriting()
{
  s << wxT( "</body>" ) << Endl;
  s << wxT( "</html>" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---   writeHeader1
**
******************************************************/
void HtmlWriter::writeHeader1( const wxString &s1 )
{
  s << wxT( "<h1><font face=\"" ) << headerFont->GetFaceName() << wxT( "\" size=+2>" ) << s1
    << wxT( "</font></h1>" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---   writeHeader2
**
******************************************************/
void HtmlWriter::writeHeader2( const wxString &s1 )
{
  s << wxT( "<h1><font face=\"" ) << headerFont->GetFaceName() << wxT( "\" size=+1>" ) << s1
    << wxT( "</font></h1>" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---   writeHeader3
**
******************************************************/
void HtmlWriter::writeHeader3( const wxString &s1 )
{
  s << wxT( "<h1><font face=\"" ) << headerFont->GetFaceName() << wxT( "\">" ) << s1
    << wxT( "</font></h1>" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---   writeParagraph
**
******************************************************/
void HtmlWriter::writeParagraph( const wxString &s1 )
{
	s << s1 << wxT( "<p>" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---   writeLine
**
******************************************************/
void HtmlWriter::writeLine( const wxString &s1 )
{
	s << s1 << wxT( "<br>" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---   writeTableHeaderEntry
**
******************************************************/
void HtmlWriter::writeTableHeaderEntry( const TableEntry &entry )
{
	s << wxT( "     <th nowrap bgcolor=" ) << bgcolor2 << wxT( "><font face=\"" )
		<< headerFont->GetFaceName() << wxT( "\">" ) << entry.value
		<< wxT ( "</font></th>" ) << Endl;
}   


/*****************************************************
**
**   HtmlWriter   ---   writeTable
**
******************************************************/
void HtmlWriter::writeTable( Table &t )
{
	writeTableIntern( t, true );
}

/*****************************************************
**
**   HtmlWriter   ---   writeTableIntern
**
******************************************************/
void HtmlWriter::writeTableIntern( Table &t, const bool &frame )
{
	unsigned int c, r;
	TableEntry entry;
	Row row;
	wxString wrap;

	if ( frame ) s << wxT( " <table border cellspacing=0 frame=box>" ) << Endl;
	else s << wxT( " <table>" ) << Endl;
	s << wxT( "		<tr>" ) << Endl;
	for( r = 0; r < t.nb_rows; r++ )
	{
		row = t.contents[r];

		// look if it's empty
		if( row.isEmpty() ) continue;

	  s << wxT( "   <tr>" ) << Endl;
		for( c = 0; c < t.nb_cols; c++ )
		{
			if ( t.col_break[c] ) wrap = wxEmptyString;
			else wrap = wxT( "nowrap" );
			entry = row.value[c];
			if ( entry.isHeader ) { writeTableHeaderEntry( entry ); }
			else if ( t.col_empty[c] )
			{
				s << wxT( "<td width=10></td>" ) << Endl;
			}
			else
			{
				switch( t.col_alignment[c] )
				{
					case TABLE_ALIGN_RIGHT:
						s << wxT( "     <td " ) << wrap << wxT( " align=right>" ) << entry.value  << wxT ( "</td>" ) << Endl;
					break;
					case TABLE_ALIGN_CENTER:
						s << wxT( "     <td " ) << wrap << wxT( " align=center>" ) << entry.value  << wxT ( "</td>" ) << Endl;
					break;
					default: // left align
						s << wxT( "     <td " ) << wrap << wxT( " align=left>" ) << entry.value  << wxT ( "</td>" ) << Endl;
					break;
				}
			}
		}
		s << wxT( "   </tr>" ) << Endl;
	}
	s << wxT( "	</table><p>" ) << Endl;
}

/*****************************************************
**
**   HtmlWriter   ---  writeListInColumns
**
******************************************************/
void HtmlWriter::writeListInColumns( const vector<wxString> v, const int &colnr )
{
	unsigned int i, j, index;
	unsigned int ePerCol = (int)v.size() / colnr;
	if ( (int)v.size() % colnr ) ePerCol++;

	Table table( colnr, ePerCol );
	for( i = 0; i < (unsigned int)colnr; i++ )
	{
		table.col_alignment[i] = TABLE_ALIGN_LEFT;
		for( j = 0; j < ePerCol; j++ )
		{
			index = i*ePerCol + j;
			if ( index < v.size() ) table.setEntry( i, j, v[index] );
		}
		s << Endl;
	}
	//writeTableIntern( table, false );
	writeTableIntern( table, true );
}

/*****************************************************
**
**   HtmlWriter   ---  writeMidpointDiagram
**
******************************************************/
void HtmlWriter::writeMidpointDiagram( vector<MidpointDiagram> mp )
{
	writeMidpointDiagramPart( mp, 0, ( mp.size() <= 13 ? mp.size() : 14 ));
	writeLine( wxT( "" ));
	if ( mp.size() > 13 ) writeMidpointDiagramPart( mp, 14, mp.size() );

}

/*****************************************************
**
**   HtmlWriter   ---  writeMidpointDiagramPart
**
******************************************************/
void HtmlWriter::writeMidpointDiagramPart( vector<MidpointDiagram> mp, const unsigned int &p1, const unsigned int &p2 )
{
	unsigned int i, j, max_row = 0;
	wxString s1;

	for( i = p1; i < p2; i++ ) max_row = Max( max_row, mp[i].entries.size());

	Table table( p2 - p1, max_row );
	for( i = p1; i < p2; i++ )
	{
		table.setHeader( i-p1, mp[i].master );
		for( j = 1; j < max_row; j++ )
		{
			if ( mp[i].entries.size() >= j )
			{
				s1.Printf( wxT( "%s-%s" ), mp[i].entries[j-1].p1.c_str(), mp[i].entries[j-1].p2.c_str());
				table.setEntry( i-p1, j, s1 );
			}
		}
	}
	// writeTableIntern( table, false );
	writeTableIntern( table, true );
}


