/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           HtmlWriter.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _HTMLWRITER_H_
#define _HTMLWRITER_H_

#ifdef __GNUG__
	#pragma interface "HtmlWriter.h"
#endif

#include "Writer.h"

class wxFont;

/*****************************************************
**
**   CLASS HtmlWriter  
**
******************************************************/
class HtmlWriter : public Writer
{
public:

	HtmlWriter();
	virtual ~HtmlWriter() {}
	virtual void beginWriting();
	virtual void endWriting();
	virtual void writeHeader1( const wxString& );
	virtual void writeHeader2( const wxString& );
	virtual void writeHeader3( const wxString& );
	virtual void writeParagraph( const wxString& );
	virtual void writeLine( const wxString& );
	virtual void writeTable( Table& );
	virtual void writeListInColumns( const vector<wxString>, const int &colnr );
	virtual void writeMidpointDiagram( vector<MidpointDiagram> );

private:
	void writeTableIntern( Table &t, const bool &paintFrame );
	void writeTableHeaderEntry( const TableEntry& );
	void writeMidpointDiagramPart( vector<MidpointDiagram> mp, const unsigned int &p1, const unsigned int &p2 );
	wxFont *headerFont, *textFont;
	wxString bgcolor, bgcolor2, fgcolor;
};

#endif


