/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           IPlanet.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "IPlanet.h"
#endif

#include "IPlanet.h"

#include "constants.h"
#include "func.h"
#include "Horoscope.h"
#include "Lang.h"
#include "Nakshatra.h"
#include "Varga.h"

/*****************************************************
**
**   IPlanet   ---   Constructor 
**
******************************************************/
IPlanet::IPlanet( Horoscope *h, const int &i )
{
	horoscope = h;
	index = i;
	length = 0;
	isRetro = false;
	shadvarga = saptavarga = dasavarga = shodasavarga = ucchabala = 0;
	dasamsa_avastha = 0;
	benefic = false;
	navamsavastha = 0;
	navamsavasthaR = 0;
	vashya = 0;
}

/*****************************************************
**
**   IPlanet   ---   getNavamsavastha 
**
******************************************************/
double IPlanet::getNavamsavastha( bool retro )
{
	return( retro ? navamsavasthaR : navamsavastha );
}

/**************************************************************
***
** IPlanet   ---   dumpYoni
***
***************************************************************/
void IPlanet:: dumpYoni( wxString &o )
{
	NakshatraExpert expert;
	Lang *lang = Lang::get();
	o << wxT( "Varna: " ) << lang->getVarnaName(getVarna( length)) << Endl;
	o << wxT( "Yoni : " ) << lang->getYoniName( expert.getYoni( length )) << Endl;
	o << wxT( "Gana : " ) << lang->getGanaName( expert.getGana( length )) << Endl;
	o << wxT( "Nadi : " ) << lang->getNadiName( expert.getNadi( length )) << Endl;
}

/*****************************************************
**
**   IPlanet   ---   update 
**
******************************************************/
void IPlanet::update()
{
	double len;
	VargaExpert expert;
	int rasi = ::getRasi( length );
	double rasilen = getRasiLen( length );

	//enum { VASHYA_QUADRUPED, VASHYA_HUMAN, VASHYA_JALACHARA, VASHYA_LEO, VASHYA_SCORPIO };
	switch( rasi )
	{
		case ARIES:
		case TAURUS:
			vashya = VASHYA_QUADRUPED;
		break;
		case GEMINI:
		case VIRGO:
		case LIBRA:
		case AQUARIUS:
			vashya = VASHYA_HUMAN;
		break;
		case CANCER:
		case PISCES:
			vashya = VASHYA_JALACHARA;
		break;
		case LEO:
			vashya = VASHYA_LEO;
		break;
		case SCORPIO:
			vashya = VASHYA_SCORPIO;
		break;
		case SAGITTARIUS:
			vashya = rasilen < 15 ? VASHYA_HUMAN : VASHYA_QUADRUPED;
		break;
		case CAPRICORNUS:
			vashya = rasilen < 15 ? VASHYA_QUADRUPED : VASHYA_JALACHARA;
		break;
		default:
			assert( 0 );
		break;
	}

	// uccha bala
	if ( index < 9 )
	{
		len = red_deg( length - k_exaltation[index] );
		if ( len > 180 ) len = 360 - len;
		ucchabala = 1 - len / 180;
	}

	if ( index <= ISATURN )
	expert.calcShadVargas( horoscope, index, shadvarga, saptavarga, dasavarga, shodasavarga, dasamsa_avastha );

	navamsavastha = 0;

	if ( index <= ISATURN )
	{
		navamsavastha = getNavamsaPortion( length, index, false );
		navamsavasthaR = getNavamsaPortion( length, index, true );
	}
}

