/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           IPlanet.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _IPLANET_H_
#define _IPLANET_H_

#ifdef __GNUG__
	#pragma interface "IPlanet.h"
#endif

#include "constants.h"

class Horoscope;

/*****************************************************
**
**   CLASS IPlanet  
**
******************************************************/
class IPlanet
{
	friend class Horoscope;
	friend class CompositHoroscope;
public:

	IPlanet( Horoscope*, const int &index );

	void update();

	bool benefic;
	double getUcchaBala() { return ucchabala; }
	double getShadVarga() { return shadvarga; }
	double getSaptaVarga() { return saptavarga; }
	double getDasaVarga() { return dasavarga; }
	double getShodasaVarga() { return shodasavarga; }
	double getDasamsaAvastha() { return dasamsa_avastha; }
	double getNavamsavastha( bool retro = true );
	int getVashya() { return vashya; }
	int getRasi() { return (int)(length/30); }
	bool isRetrograde() { return isRetro; }
	double getLength() { return length; }
	int getIndex() { return index; }
	void dumpYoni( wxString &o );

private:
	Horoscope *horoscope;
	int index;
	double length;
	bool isRetro;
	int vashya;

	double shadvarga, saptavarga, dasavarga, shodasavarga, ucchabala;
	double dasamsa_avastha;
	double navamsavastha;
	double navamsavasthaR;
};

#endif


