/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           JaiminiDasa.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "JaiminiDasa.h"
#endif

#include "JaiminiDasa.h"
#include "Dasa.h"
#include "IPlanet.h"
#include "Horoscope.h"
#include "func.h"
#include "Jaimini.h"
#include "Varga.h"
#include "Lang.h"

/*****************************************************
**
**   JaiminiDasaExpert   ---   Constructor 
**
******************************************************/
JaiminiDasaExpert::JaiminiDasaExpert( const int &type )
{
	assert( type == DASA_SHULA
		|| type == DASA_SHULA39
		|| type == DASA_SHULA410
		|| type == DASA_SHULA511 );
	this->type = type;
}

/**************************************************************
***
** JaiminiDasaExpert  ---  getName
***
***************************************************************/
const wxChar *JaiminiDasaExpert::getName()
{
	switch( type )
	{
		case DASA_SHULA:
			return _( "Shula" );
		break;
		case DASA_SHULA39:
			return _( "Shula 3/9" );
		break;
		case DASA_SHULA410:
			return _( "Shula 4/10" );
		break;
		case DASA_SHULA511:
			return _( "Shula 5/11" );
		break;
		default:
			assert( false );
		break;
	}
	assert( 0 );
	return wxT( "Dummy" );
}

/*****************************************************
**
**   JaiminiDasaExpert   ---   calcNarayanaSteps 
**
******************************************************/
void JaiminiDasaExpert::calcNarayanaSteps( const int &start_rasi, VargaView *view )
{
	int i, s;
	bool calcForward = false;

	if ( isOddFootedRasi( red12( start_rasi + 8 ) )) calcForward = true;

	// Exception: Saturn or Ketu in dasa rasi
	if ( view->getRasi( ISATURN ) == start_rasi )
	{
		calcForward = true;
	}
	else if ( view->getRasi( IKETU ) == start_rasi )
	{
		calcForward = !calcForward;
	}

	if ( ! ( start_rasi % 3 ) || ( view->getRasi( ISATURN ) == start_rasi ))
	{
		calcForward ? s = 1 : s = -1;
		for( i = 0; i < 12; i++ ) step[i] = red12( start_rasi + i * s );
	}
	else if ( ( start_rasi % 3 ) == 1 )
	{
		calcForward ? s = 5 : s = -5;
		for( i = 0; i < 12; i++ ) step[i] = red12( start_rasi + i * s );
	}
	else
	{
		if ( calcForward )
		{
			int mysteps[12] = { 0, 4, 8, 9, 1, 5, 6, 10, 2, 3, 7, 11 };
			for( i = 0; i < 12; i++ ) step[i] = red12( start_rasi + mysteps[i] );
		}
		else
		{
			//int mysteps[12] = { 1, 9, 5, 4, 0, 8, 7, 11, 3, 2, 6, 10 };
			int mysteps[12] = { 0, 8, 4, 3, 11, 7, 6, 2, 10, 9, 5, 1 };
			for( i = 0; i < 12; i++ ) step[i] = red12( start_rasi + mysteps[i] );
		}
	}
}


/*****************************************************
**
**   <-- JaiminiDasaExpert   ---   getNextLevel -->
**
******************************************************/
vector<Dasa*> JaiminiDasaExpert::getNextLevel( Dasa *dasa )
{
	vector<Dasa*> ret;

	VargaView *view = ((RasiDasaImpl*)dasa)->getVargaView();
	JaiminiExpert expert( view );
	expert.update();

	double start_jd = dasa->getStartJD();
	double end_jd;
	double step_len = ( dasa->getEndJD() - dasa->getStartJD() ) / 12;

	int dasarasi = expert.getStrongerRasi( dasa->getDasaLord(), red12( dasa->getDasaLord() + 6 ));
	int step_dir = 1;

	switch( type )
	{
		case DASA_SHULA:
		case DASA_SHULA39:
		case DASA_SHULA410:
		case DASA_SHULA511:
			start_rasi = dasarasi;
		break;
		default:
			assert( false );
		break;
	}

	for( int i = 0; i < 12; i++ )
	{
		end_jd = start_jd + step_len;
		RasiDasaImpl *d = new RasiDasaImpl( this, view, start_rasi, start_jd, end_jd, wxT( "" ), dasa );
		ret.push_back( d );

		start_jd = end_jd;
		start_rasi = red12( start_rasi + step_dir );
	}
	return ret;
}

/*****************************************************
**
**   <-- JaiminiDasaExpert   ---   getFirstLevel -->
**
******************************************************/
vector<Dasa*> JaiminiDasaExpert::getFirstLevel( Horoscope *h, int varga )
{
	int i;
	vector<Dasa*> ret;

	VargaExpert vexpert;
	VargaView *view = new VargaView( h, varga );
	JaiminiExpert jexpert( view );
	jexpert.update();

	switch( type )
	{
		case DASA_SHULA:
			start_rasi = view->getRasi( IASCENDANT );
		break;
		case DASA_SHULA39:
			start_rasi = red12( view->getRasi( IASCENDANT ) + 2 );
		break;
		case DASA_SHULA410:
			start_rasi = red12( view->getRasi( IASCENDANT ) + 3 );
		break;
		case DASA_SHULA511:
			start_rasi = red12( view->getRasi( IASCENDANT ) + 4 );
		break;
		default:
			assert( false );
		break;
	}
	start_rasi = jexpert.getStrongerRasi( start_rasi, red12( start_rasi + 6 ));

	double start_jd = h->getJD();
	double end_jd;

	switch( type )
	{
		case DASA_SHULA:
		case DASA_SHULA39:
		case DASA_SHULA410:
		case DASA_SHULA511:
			for( i = 0; i < 12; i++ )
			{
				end_jd = start_jd + 9 * getYearLength( true );

				ret.push_back( new RasiDasaImpl( this, view, start_rasi, start_jd, end_jd, wxT( "" ), 0 ));

				start_jd = end_jd;
				start_rasi = red12( start_rasi + 1 );
			}
		break;
		default:
			assert( 0 );
		break;
	}
	return ret;
}


