/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           JaiminiDasa.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _JAIMINIDASA_H_
#define _JAIMINIDASA_H_

#ifdef __GNUG__
	#pragma interface "JaiminiDasa.h"
#endif

#include "constants.h"
#include "Dasa.h"

class VargaView;

/*****************************************************
**
**   CLASS JaiminiDasaExpert  
**
******************************************************/
class JaiminiDasaExpert : public RasiDasaExpert
{
public:

	JaiminiDasaExpert( const int &type );
	virtual vector<Dasa*> getFirstLevel( Horoscope*, int varga = 0 );
	virtual vector<Dasa*> getNextLevel( Dasa* );
	virtual const wxChar *getName();
	virtual const int getType();

private:
	JaiminiDasaExpert() {};
	void calcNarayanaSteps( const int&, VargaView* );
	int step[12];
	int type, start_rasi;
};


/**************************************************************
***
** Inline Declarations
***
***************************************************************/

inline const int JaiminiDasaExpert::getType()
{
	return DASA_TYPE_SIGN;
}

#endif

