/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           KalachakraDasa.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _KALACHAKRADASA_H_
#define _KALACHAKRADASA_H_

#ifdef __GNUG__
	#pragma interface "KalachakraDasa.h"
#endif

#include "Dasa.h"
#include "constants.h"

class Horoscope;

/*****************************************************
**
**   CLASS KalachakraDasaImpl  
**
******************************************************/
class KalachakraDasaImpl : public DasaImpl
{
public:

	KalachakraDasaImpl( DasaExpert*, const int &lord, const double &startjd, const double &endjd, const int &pada, const int &group,
			const wxChar *extraText, Dasa* = 0 );

	int getGroup() { return group; }
	int getPada() { return pada; }

protected:
	int pada;
	int group;
};

/*****************************************************
**
**   CLASS KalachakraDasaExpert  
**
******************************************************/
class KalachakraDasaExpert : public RasiDasaExpert
{
public:

	KalachakraDasaExpert();
	virtual vector<Dasa*> getFirstLevel( Horoscope*, const int varga = 0 );
	virtual vector<Dasa*> getNextLevel( Dasa* );
	virtual const wxChar *getName() { return _( "Kalachakra" ); }
	virtual bool hasKpFeatures() { return true; }
  virtual vector<KPEvent> getKPEventList( const double &startlen, const double &Endlen, const double &startjd );
	void getKPLord( const double &len, int &lord, int &sublord );

private:
	int deha, jeeva;
	bool savya;
	static const wxChar K_KALA[4][4][9];
	static const int K_RASIYEARS[12];
	static const int K_TOTALYEARS[4][4];
};

#endif

