/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Lang.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _LANG_H_
#define _LANG_H_

#ifdef __GNUG__
	#pragma interface "Lang.h"
#endif

#include<constants.h>

#define FORMAT_DEGREE         1
#define FORMAT_HOUR           2
#define FORMAT_SHOW_SECONDS  16
#define FORMAT_RED_RASI      32
#define FORMAT_SHOW_DIR      64

enum { DEG_PRECISION_MINUTE, DEG_PRECISION_SECOND, DEG_PRECISION_MORE };
enum { DIR_NONE = -1, DIR_DIRECT, DIR_RETROGRADE, DIR_STATIONARY, DIR_DIRECT_SHOW };

/*****************************************************
**
**   CLASS Lang  
**
******************************************************/
class Lang
{
public:

	enum { SID_GRADKREIS, SID_ORBIS, SID_RADIXPOSITIONS, SID_MINUTES, SID_DEGREES, SID_KONJUNCTIONS,
		SID_TABLE, SID_DIAGRAM, SID_MIDPOINTS, SID_CHAINS };

	static Lang *get();

	// get weekday name (0..6, sunday is 0)
	const wxString getWeekdayName( const int& );
	const wxString getMonthName( const int &i );

	const wxString getYoniName( const int& );
	const wxString getGanaName( const int& );
	const wxString getNadiName( const int& );
	const wxString getVarnaName( const int& );
	const wxString getTaraName( const int& );
	const wxString getTithiName( const int& );
	const wxString getBhavaName( const int &i );

	// name of object
	const wxString getObjectName( const int &num, const int &format );

	// name of object by object index
	const wxString getOListObjectName( const int &num, const int &format );

	// name of sign
	const wxString getSignName( const int &i, const int format = TSHORT );

	//const wxChar getSignSymbolCode( const int &i );
	//const wxChar getPlanetSymbolCode( const int &i );

	const wxString getNakshatraName( const int &nak, const int &nsys, const int &format );
	// map from o-index to w-index
	int mapO2WIndex( const int &i );

	const wxString getKarakaName( const int &i, const int format = TLARGE );
	const wxString getShastiamsaName( const int &i );

private:
	Lang();
	static Lang *ego;

};

/*****************************************************
**
**   CLASS Formatter  
**
******************************************************/
class Formatter
{
public:

	static Formatter *get();

	// get the integers for day, month and year from jd
	void getDateIntsFromJD( const double &jd, int &day, int &month, int &year, const int format = 0 );

	// parses date string and calculates day, month and year
  bool getDateIntsFromString( const wxChar *value, int &day, int &month, int &year, const int format = 0 );

	// formats a date which is given by jd
  const wxString getDateStringFromJD( const double &jd, int format = 0 );

	// formats a date which is given by jd (including time in GT)
  const wxString getFullDateStringFromJD( const double &jd, const int format = 0 );

	// calculates degrees, minutes and seconds from a given length from a (double) degree value
  void getDegMinSecInts( const double &len, int &deg, int &min, int &sec );
  void getDegMinSecInts2( const double &len, int &deg, int &min, double &sec );

	// formats a length like DD:MM:SS
  const wxString getLenFormated( const double &len, const int &format = DEG_PRECISION_SECOND );

	// formats a latitude like DD:MM:SS  [N|S]
  const wxString getLatitudeFormated( const double&, const int = DEG_PRECISION_SECOND );

	// formats a longitude like DD:MM:SS  [E|W]
  const wxString getLongitudeFormated( const double&, const int = DEG_PRECISION_SECOND );

	// formats a time value like HH:MM:SS
  const wxString getTimeFormated( const double &t );

	// formats a degree value like DD:MM:SS
  const wxString getDegreesFormated( const double&, const int = DEG_PRECISION_SECOND );

	// formats a planetyry position in the format NAME [R] DD:MM:SS SIGN
	wxString getPosFormatted( const double &len, const int &dir = DIR_NONE, const int &precision = DEG_PRECISION_SECOND );

	// parses a degree string DD:MM:SS
	bool getDegreeIntsFromString( const wxChar *value, int &deg, int &minute, int &second, int format = 0 );

	// Calculates a length string
	const wxString getLenString( const double &len, const int format = 0, const int dir = 0 );

	// name of ayanamsa
	const wxString getAyanamsaName( const int &ayatype ); 

private:
	Formatter();
	static Formatter *ego;
};

#endif

