/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Midpoint.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _MIDPOINT_H_
#define _MIDPOINT_H_

#ifdef __GNUG__
	#pragma interface "Midpoint.h"
#endif

#include "constants.h"
#include <wx/string.h>
#include <list>
#include <vector>

#define HMAX_PLANET 22

using namespace std;

class DataSet;
class Horoscope;
class Location;
class Writer;


enum { MIDPOINT_SORT_PLANET2 = 0, MIDPOINT_SORT_ORBIS, MIDPOINT_SORT_ORBIS_BETRAG, MIDPOINT_SORT_PLANET1,
	MIDPOINT_SORT_ASPECT, MIDPOINT_SORT_DATUM, MIDPOINT_SORT_ORBIS_REV, MIDPOINT_SORT_JD };

/***************************************************
***
**  CLASS   ---   MidpointValue
***
***************************************************/
struct MidpointValue
{
	MidpointValue( const int &pl1, const int &i1, const int &pl2, const int &i2, const double &value )
		{ p1 = pl1; this->i1 = i1; p2 = pl2; this->i2 = i2; wert = value; }
	int p1, i1, p2, i2;
	double wert;
};

/***************************************************
***
**  CLASS   ---   MidpointEvent
***
***************************************************/
struct MidpointEvent
{
	MidpointEvent( int p, int i0, int h1, int i1, int h2, int i2, double orbis, int type, double jd = 0 );
	void write( Writer *writer, wxString &o, bool show_datum = false );
	int p, i0, h1, i1, h2, i2, type;
	double orbis, jd;
};

/***************************************************
***
**  CLASS   ---   ConjunctionEvent
***
***************************************************/
struct ConjunctionEvent
{
	ConjunctionEvent( const int &p1, const int &i1, const int &p2, const int &i2, const double &orb, const int &type, const double jd = 0 );
	void write( Writer *writer, wxString &o, bool show_datum = false );
	int p1, p2, i1, i2, type;
	double orbis, jd;
};

/***************************************************
***
**  CLASS   ---   TextEntry
***
***************************************************/
struct TextEntry
{
	TextEntry( const wxChar *code, const wxChar *value );
	wxChar code[10];
	wxString text;
};

/*****************************************************
**
**   CLASS MidpointExpert  
**
******************************************************/
class MidpointExpert
{
public:

	MidpointExpert( int hsSystem );
	static const wxChar *getEventSymbol( Writer *writer, const int &i );

	void writeRadixAnalysis( Writer*, Horoscope *h, const double &orbis, const int gradkreis = GRADKREIS_45,
		const int order = MIDPOINT_SORT_PLANET2, const int filter = -1 );

	void writeSolarArcAnalysis( Writer*, DataSet *basedate, DataSet *transitdate, const double &red, const double &orbis,
		const int gradkreis = GRADKREIS_45, const int order = MIDPOINT_SORT_PLANET2, const int filter = -1 );

	double writePlanetaryArcAnalysis( Writer*, const int &planet, DataSet *basedate, DataSet *transitdate,
		const double &red, const double &orbis, const int gradkreis = GRADKREIS_45,
		const int order = MIDPOINT_SORT_PLANET2, const int filter = -1 );

	void writeYearlyPreviewAnalysis( Writer *writer, DataSet *basedate, const double &red,
		const int &gradkreis, const int &jahr );

	void writeChainAnalysis( Writer*, Horoscope *h, const double &orbis,
		const int gradkreis = GRADKREIS_45, const int order = MIDPOINT_SORT_PLANET2, const int viewmodus = 0 );

	void writeTransitAnalysis( Writer*, DataSet *basedate, DataSet *transitdate, const double &orbis,
		const int gradkreis = GRADKREIS_45, const int order = MIDPOINT_SORT_PLANET2 );

	void writeDirectionAnalysis( Writer*, DataSet *basedate, DataSet *transitdate, const double &red,
		const double &orbis, const int gradkreis = GRADKREIS_45, const int order = MIDPOINT_SORT_PLANET2,
		const int filter = -1 );

	void writeConstantArcAnalysis( Writer*, DataSet *basedate, DataSet *transitdate,	const double &red,
		const double &orbis, const int gradkreis = GRADKREIS_45, const int order = MIDPOINT_SORT_PLANET2 );

	void writePartnerAnalysis( Writer*, Horoscope *partner1, Horoscope *partner2, const double &orbis,
		const int gradkreis = GRADKREIS_45, const int order = MIDPOINT_SORT_PLANET2, const int filter = -1 );

private:

	int hsSystem;
	void updatePList();
	void updateTextEntries();
	void updatePos( const int &which, DataSet*  );

	void calculateEvents( const int &which1, const int &which2, const double &orbis,
		const int gradkreis = GRADKREIS_45, const int order = MIDPOINT_SORT_PLANET2, const int filter = -1 );

	void writePlanetaryPositions( Writer*, const int &which, const int &gradkreis );
	void writeMidpoints( Writer*, const int &which, const int gradkreis = GRADKREIS_45 );
	void writeConjunctions( Writer*, bool show_datum = false );
	void writeMidpointEvents( Writer*, bool show_datum = false );
	void writeMidpointDiagram( Writer*, const int &which1, const int &which2, const double &orbis,
		const int gradkreis = GRADKREIS_45, const int filter = -1 );
	double writeArcEventAnalysis( Writer *writer, const double &bogen, DataSet *basedate, DataSet *transitdate,
		const double &red, const double &orbis, const int gradkreis = GRADKREIS_45,
		const int order = MIDPOINT_SORT_PLANET2, const int filter = -1 );

	void writeMidpointEventsText( Writer*, const bool show_datum = false );
	void getTextOutput( wxChar *buf, wxChar *filename, const int &p, const int &h1, const int &h2 );

	double calcSolarArcEvent( DataSet *basedate, const double &transitjd, const double &red, const int &planet,
		const double &targetpos, const int &gradkreis );
	double calcAscendantFromMC( const double &jd, const double &mc, const double &breite );

	int mapPlanetsToNumberE( const int &p, const int &h1, const int &h2 );
	void getPlanetaryIndexW( char *buf, const int &p, const int &h1, const int &h2 );
	int mapOToENumber( const int &p );
	int mapOToWNumber( const int &p );

	double pos1[HMAX_PLANET], pos2[HMAX_PLANET];
	unsigned int aspos, mcpos, sunpos;
	list <MidpointEvent> midpoint_events;
	list <ConjunctionEvent> conjunction_events;
	list <MidpointValue> midpoint_values;
	list <TextEntry> text_entries;
	vector<int> plist;
};

#endif


