/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Nakshatra.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Nakshatra.h"
#endif

#include "Nakshatra.h"

#include "Horoscope.h"
#include "func.h"
#include "Lang.h"
#include "constants.h"
#include "Conf.h"
#include "Varga.h"
#include "Writer.h"

#include <wx/string.h>
#include <math.h>
#include <assert.h>

extern Config *config;



/*****************************************************
**
**   NakshatraExpert   ---   getYoni 
**
******************************************************/
int NakshatraExpert::getYoni( const double& len )
{
	assert( len >= 0 & len <= 360 );
	int nakshatra = getNakshatra( len, N27 );
	const int yoni_map[27] =
	{
		0, 3, 4, 7, 7, 9, 10, 4, 10,
		9, 11, 13, 1, 12, 1, 12, 8, 8,
		9, 5, 6, 5, 2, 0, 2, 13, 3
	};
	return yoni_map[nakshatra];
}

/*****************************************************
**
**   NakshatraExpert   ---   getNadi 
**
******************************************************/
int NakshatraExpert::getNadi( const double& len )
{
	assert( len >= 0 & len <= 360 );
	int nakshatra = getNakshatra( len, N27 );

	const int nadi_map[27] =
	{
		0, 1, 2, 2, 1, 0, 0, 1, 2,
		2, 1, 0, 0, 1, 2, 2, 1, 0,
		0, 1, 2, 2, 1, 0, 0, 1, 2
	};
	return nadi_map[nakshatra];
}

/*****************************************************
**
**   NakshatraExpert   ---   getGana 
**
******************************************************/
int NakshatraExpert::getGana( const double& len )
{
	assert( len >= 0 & len <= 360 );
	int nakshatra = getNakshatra( len, N27 );

	const int gana_map[27] =
	{
		0, 1, 2, 1, 0, 1, 0, 0, 2,
		2, 1, 1, 0, 2, 0, 2, 0, 2,
		2, 1, 1, 0, 2, 2, 1, 1, 0
	};
	return gana_map[nakshatra];
}

/*****************************************************
**
**   NakshatraExpert   ---   getTara
**
******************************************************/
int NakshatraExpert::getTara( const int& nak )
{
	int n = nak;
	if ( n < 0 ) n += 27;
	assert( n >= 0 && n < 27 );
	return n % 9;
}

/*****************************************************
**
**   NakshatraExpert   ---   write
**
******************************************************/
void NakshatraExpert::write( Writer *writer )
{
	assert( view );
	wxString s;
	double nak_len;
	int nakshatramode =  ( config->iNakshatraMode28 ? N28 : N27 );

	Formatter *formatter = Formatter::get();
	Lang      *lang      = Lang::get();

	writer->writeHeader1( _( "Nakshatras" ));
	Table table( nakshatramode == N27 ? 7 : 3 , 24 );
	table.setHeader( 0,  _( "Planet" ));
	table.setHeader( 1,  _( "Length" ));
	table.setHeader( 2,  _( "Nakshatra" ));
	if ( nakshatramode == N27 )
	{
		table.setHeader( 3,  _( "Yoni" ));
		table.setHeader( 4,  _( "Gana" ));
		table.setHeader( 5,  _( "Nadi" ));
		table.setHeader( 6,  _( "Tara" ));
	}

	int line = ISUN+1;
	for( int i = ISUN; i < MAX_IOBJECTS_LAGNA_UPA; i++ )
	{
		table.setEntry( 0, line, Lang::get()->getObjectName( i, TLARGE ));
		nak_len = getNakshatraLength( view->getLength( i ), nakshatramode );
		table.setEntry( 1, line, formatter->getPosFormatted( view->getLength( i )));
		table.setEntry( 2, line, lang->getNakshatraName( view->getNakshatra( i, nakshatramode ), nakshatramode, TMEDIUM) );

		// This is not defined for 28 nakshatra mode, so leave it out
		if ( nakshatramode == N27 )
		{
			table.setEntry( 3, line, lang->getYoniName( getYoni( view->getLength( i ))) );
			table.setEntry( 4, line, lang->getGanaName( getGana( view->getLength( i ))) );
			table.setEntry( 5, line, lang->getNadiName( getNadi( view->getLength( i ))) );
			table.setEntry( 6, line, lang->getTaraName(
				getTara(  view->getNakshatra( i, N27 ) - view->getNakshatra( IMOON, N27 ))));
		}
		line++;
	}
	writer->writeTable( table ); 
}





