/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           PrintoutHelper.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "PrintoutHelper.h"
#endif

#include "PrintoutHelper.h"

#include <wx/log.h>
#include <wx/string.h>
#include <math.h>

#include "Ashtakavarga.h"
#include "func.h"
#include "constants.h"
#include "IPlanet.h"
#include "Horoscope.h"
#include "Jaimini.h"
#include "Nakshatra.h"
#include "Lang.h"
#include "constants.h"
#include "Conf.h"
#include "Varga.h"
#include "Writer.h"

extern Config *config;

/*****************************************************
**
**   PrintoutHelper   ---   Constructor
**
******************************************************/
PrintoutHelper::PrintoutHelper( Horoscope *hh, Writer *ww )
{
	h = hh;
	writer = ww;
}

/*****************************************************
**
**   PrintoutHelper   ---   Destructor
**
******************************************************/
PrintoutHelper::~PrintoutHelper()
{
	delete table;
}


/*****************************************************
**
**   PrintoutHelper   ---   writeBaseData
**
******************************************************/
void PrintoutHelper::writeBaseData()
{
	wxString s;
	int line = 1;
	double thetime;
	Formatter *f = Formatter::get();

	DataSet *ds = h->getDataSet();
	Location *loc = ds->getLocation();
	JDate *date = ds->getDate();

	table->setEntry( 0, line,  _( "Date" ));
	s << f->getDateStringFromJD( h->getJD() + ( loc->getTimeZone() + loc->getDST() )/24 )
		<< wxT( " " ) << Lang::get()->getWeekdayName(date->getWeekDay());
	table->setEntry( 1, line++, s );

	table->setEntry( 0, line,  _( "Local Time" ));
  thetime = a_red( getTimeFromJD( date->getJD()) + loc->getTimeZone() + loc->getDST(), 24 );
	table->setEntry( 1, line++, f->getTimeFormated( thetime ));

	table->setEntry( 0, line,  _( "Location" ));
	table->setEntry( 1, line++, loc->getLocName() );

	table->setEntry( 0, line,  _( "Longitude" ));
	table->setEntry( 1, line++, f->getLongitudeFormated( loc->getLongitude()));

	table->setEntry( 0, line,  _( "Latitude" ));
	table->setEntry( 1, line++, f->getLatitudeFormated( loc->getLatitude()));

	table->setEntry( 0, line,  _( "Time Zone" ));
	double tz = loc->getTimeZone();
  s.Printf( wxT( "%s %c%.1f" ), _( "UT" ), ( tz >= 0 ? '+' : '-' ), tz );
	table->setEntry( 1, line++, s );

	table->setEntry( 0, line,  _( "Daylight Saving" ));
  s.Printf( wxT( "%.1f" ), loc->getDST());
	table->setEntry( 1, line++, s );

	table->setEntry( 0, line,  _( "Universal Time" ));
	table->setEntry( 1, line++, f->getTimeFormated( getTimeFromJD( h->getJD() )));

	table->setEntry( 0, line,  _( "Sidereal Time" ));
	table->setEntry( 1, line++, f->getTimeFormated( h->getSiderealTime()));

	table->setEntry( 0, line,  _( "Julian Date" ));
  s.Printf( wxT( "%8.5f" ), h->getJD());
	table->setEntry( 1, line++, s );
}



/*****************************************************
**
**   PrintoutHelper   ---   writeWesternPlanets
**
******************************************************/
void PrintoutHelper::writeWesternPlanets()
{
	int i;
	Formatter *f = Formatter::get();
	Lang *lang = Lang::get();
	wxString s;

	table->setHeader( 2,  _( "Planet" ));
	table->setHeader( 3,  _( "Length" ));
	if ( style == 1 )
	{
		table->setHeader( 4,  _( "Planet" ));
		table->setHeader( 5,  _( "Length" ));
	}
	else
	{
		table->setHeader( 4,  _( "House" ));
		table->setHeader( 5,  _( "Cusp" ));
		table->setHeader( 6,  _( "Length" ));
	}

	int line = 1;
	for(  i = WSUN; i <= WLUNARNODE; i++ )
	{
		table->setEntry( 2, line, lang->getObjectName(i, TLARGE) );
		table->setEntry( 3, line, f->getPosFormatted( h->getObjectLength( i ), h->isObjectRetrograde(i), DEG_PRECISION_SECOND ) );
		if ( style != 1 )
		{
			s.Printf( wxT( "%02d" ), h->getHousePos( i ) + 1 );
			table->setEntry( 4, line, s );
		}
		line++;
	}
	if ( style == 1 )
	{
		table->col_line[3] = true;
		line = 1;
		table->setEntry( 4, line, lang->getObjectName( WASCENDANT, TLARGE) );
		table->setEntry( 5, line++, f->getPosFormatted( h->getHouse( HOUSE1, false), false ));

		table->setEntry( 4, line, lang->getObjectName( WMC, TLARGE) );
		table->setEntry( 5, line++, f->getPosFormatted( h->getHouse( HOUSE10, false), false ));
		for(  i = WCUPIDO; i <= WPOSEIDON; i++ )
		{
			table->setEntry( 4, line, lang->getObjectName(i, TLARGE) );
			table->setEntry( 5, line, f->getPosFormatted( h->getObjectLength( i ), h->isObjectRetrograde(i), DEG_PRECISION_SECOND ));
			line++;
		}
	}
	else
	{
		table->col_line[4] = true;
		line = 1;
		table->setEntry( 5, line, lang->getObjectName( WASCENDANT, TLARGE) );
		table->setEntry( 6, line++, f->getPosFormatted( h->getHouse( HOUSE1, false), false ));

		table->setEntry( 5, line, lang->getObjectName( WMC, TLARGE) );
		table->setEntry( 6, line++, f->getPosFormatted( h->getHouse( HOUSE10, false), false ) );

		table->setEntry( 5, line, wxT( "11" ));
		table->setEntry( 6, line++, f->getPosFormatted( h->getHouse( HOUSE11, false), false ) );

		table->setEntry( 5, line, wxT( "12" ));
		table->setEntry( 6, line++, f->getPosFormatted( h->getHouse( HOUSE12, false), false ) );

		table->setEntry( 5, line, wxT( "02" ));
		table->setEntry( 6, line++, f->getPosFormatted( h->getHouse( HOUSE2, false), false ) );

		table->setEntry( 5, line, wxT( "03" ));
		table->setEntry( 6, line++, f->getPosFormatted( h->getHouse( HOUSE3, false), false ) );

	}
}

/*****************************************************
**
**   PrintoutHelper   ---   writeVedicDefault
**
******************************************************/
void PrintoutHelper::writeVedicDefault()
{
	int i;
	Lang *lang = Lang::get();
	Formatter *f = Formatter::get();

	VargaView view( h, 0 );
	VargaView nview( h, 1 );
	JaiminiExpert jexpert( &nview );
	jexpert.calcCharaKarakas();
  NakshatraExpert nexpert;

	table->setHeader( 2,  _( "Planet" ));
	table->setHeader( 3,  _( "Length" ));
	table->setHeader( 4,  _( "Karaka" ));
	table->setHeader( 5,  _( "Navamsa" ));
	table->setHeader( 6,  _( "Nakshatra" ));
  int line = 1;
  for( i = ISUN; i <= IASCENDANT; i++ )
  {
    table->setEntry( 2, line,  lang->getObjectName( i, TLARGE ));
    table->setEntry( 3, line,  f->getPosFormatted( h->getObjectLength(i), h->isObjectRetrograde(i)) ); 
    
    if ( i <= IRAHU )  table->setEntry( 4, line, lang->getKarakaName( jexpert.getCharaKarakaProperty(i)) );

    table->setEntry( 5, line, lang->getSignName(nview.getRasi( i ), config->signPrecision ));
    table->setEntry( 6, line, lang->getNakshatraName(view.getNakshatra(i, N27), N27, TLARGE ) );
    line++;
  }
}

/*****************************************************
**
**   PrintoutHelper   ---   writeVedicKp
**
******************************************************/
void PrintoutHelper::writeVedicKp()
{
	int i;
	Lang *lang = Lang::get();
	Formatter *f = Formatter::get();

	VargaView view( h, 0 );
	VargaView nview( h, 1 );
	JaiminiExpert jexpert( &nview );
	jexpert.calcCharaKarakas();
  NakshatraExpert nexpert;
	h->updateKP( 0 );

	table->setHeader( 2,  _( "Planet" ));
	table->setHeader( 3,  _( "Length" ));
	table->setHeader( 4,  _( "Nakshatra" ));
	table->setHeader( 5,  _( "Lord" ));
	table->setHeader( 6,  _( "Sublord" ));
  int line = 1;
  for( i = ISUN; i <= IASCENDANT; i++ )
  {
    table->setEntry( 2, line,  lang->getObjectName( i, TLARGE ));
    table->setEntry( 3, line, f->getPosFormatted( h->getObjectLength(i), h->isObjectRetrograde(i)) ); 
    table->setEntry( 4, line, lang->getNakshatraName(view.getNakshatra(i, N27), N27, TLARGE ) );
		table->setEntry( 5, line, lang->getObjectName( h->getKPLord( i, false ), TLARGE ));
		table->setEntry( 6, line, lang->getObjectName( h->getKPLord( i, true ), TLARGE ));
    line++;
  }

}

/*****************************************************
**
**   PrintoutHelper   ---   writePrintoutSummary
**
******************************************************/
void PrintoutHelper::writePrintoutSummary( const int &st )
{
	wxString s;

	style = st;
	int num_cols = 10;
	int num_rows = 30;

	switch( style )
	{
		case PSUM_WDEFAULT:
			num_rows = 12;
			num_cols = 7;
		break;
		case PSUM_WURANIAN:
			num_rows = 12;
			num_cols = 6;
		break;
		case PSUM_VDEFAULT:
			num_rows = 11;
			num_cols = 7;
		break;
		case PSUM_VKP:
			num_rows = 11;
			num_cols = 7;
		break;
		default:
			assert( false );
		break;
	}

	table = new Table( num_cols, num_rows );
	table->col_line[1] = true;
	table->col_alignment[0] = TABLE_ALIGN_RIGHT;
	table->col_alignment[2] = TABLE_ALIGN_RIGHT;
	//table->col_alignment[3] = TABLE_ALIGN_RIGHT;
	table->setHeader( 0,  wxT( "" ));
	table->setHeader( 1,  wxT( "" ));

	writeBaseData();
	if ( style == 2 ) writeVedicDefault();
	else if ( style == 3 ) writeVedicKp();
	else writeWesternPlanets();
	writer->writeTable( *table ); 
}



