/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           PrintoutHelper.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _PRINTOUTHELPER_H_
#define _PRINTOUTHELPER_H_

#ifdef __GNUG__
	#pragma interface "PrintoutHelper.h"
#endif

#include <wx/string.h>
#include <vector>

using namespace std;

#include "constants.h"

class Horoscope;
class Table;
class Writer;

enum { PSUM_WDEFAULT = 0, PSUM_WURANIAN, PSUM_VDEFAULT, PSUM_VKP };

/*****************************************************
**
**   CLASS PrintoutHelper
**
******************************************************/
class PrintoutHelper
{

public:
	PrintoutHelper( Horoscope*, Writer* );
	~PrintoutHelper();
	void writePrintoutSummary( const int& );

private:
	void writeBaseData();
	void writeWesternPlanets();
	void writeVedicDefault();
	void writeVedicKp();

	int style;
	Horoscope *h;
	Writer *writer;
	bool preferVedic;
	bool umode;
	Table *table;

};


#endif


