/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Session.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Session.h"
#endif

#include "Session.h"

#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/log.h>
#include <wx/tokenzr.h>
#include <wx/utils.h>

#ifndef __WXMSW__
#include <errno.h>
#include <stdio.h>
#include <assert.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#endif

#include "AshtottariDasa.h"
#include "Calculator.h"
#include "Conf.h"
#include "config.h"
#include "func.h"
#include "GenericDasa.h"
#include "Horoscope.h"
#include "JaiminiDasa.h"
#include "KalachakraDasa.h"
#include "Lang.h"
#include "VimsottariDasa.h"

extern Config *config;
Session *Session::ego = 0;
/**************************************************************
***
** Session   ---   get
***
***************************************************************/
Session *Session::get()
{
	if ( ! ego ) ego = new Session();
	return ego;
}

/*****************************************************
**
**   Session   ---   Constructor 
**
******************************************************/
Session::Session()
{
	bindir = wxT( "." );
	configdir = wxT( "." );
	viewdir = wxT( "view" );
#ifndef __WXMSW__
	prepareConfigDir();
#endif

	// Dasa Experts
	dasa_experts.push_back( new VimsottariDasaExpert() );
	dasa_experts.push_back( new YoginiDasaExpert() );
	dasa_experts.push_back( new KalachakraDasaExpert() );
	dasa_experts.push_back( new AshtottariDasaExpert() );
	dasa_experts.push_back( new ShodshottariDasaExpert() );
	dasa_experts.push_back( new DvadashottariDasaExpert() );
	dasa_experts.push_back( new PanchottariDasaExpert() );
	dasa_experts.push_back( new ShatabdikaDasaExpert() );
	dasa_experts.push_back( new ChaturashitiSamaDasaExpert() );
	dasa_experts.push_back( new DvisaptatiSamaDasaExpert() );
	dasa_experts.push_back( new ShatTrimshatSamaDasaExpert() );
	dasa_experts.push_back( new LagnaVimsottariDasaExpert() );

	//dasa_experts.push_back( new JaiminiDasaExpert( DASA_NARAYANA ));
	dasa_experts.push_back( new JaiminiDasaExpert( DASA_SHULA ));
	dasa_experts.push_back( new JaiminiDasaExpert( DASA_SHULA39 ));
	dasa_experts.push_back( new JaiminiDasaExpert( DASA_SHULA410 ));
	dasa_experts.push_back( new JaiminiDasaExpert( DASA_SHULA511 ));
}

/*****************************************************
**
**   Session   ---   Destructor 
**
******************************************************/
Session::~Session()
{
	clear();
}

/*****************************************************
**
**   Session   ---   init
**
******************************************************/
void Session::init( const wxChar *s )
{
	config = new Config();
	config->readAll();
	calculator = new CalculatorSwe();

	setAppPath( s );

#ifndef __WXMSW__
	wxString locfile, locBase, err;
	locfile = getLocationFile();
	locBase = bindir;

	if ( locBase.Last() != wxFileName::GetPathSeparator() ) locBase << wxFileName::GetPathSeparator();
	locBase << wxT( "locations.dat" );

  if ( wxAccess( locfile.c_str(), F_OK ))
	{
		err.Printf( wxT( "Copy file %s to %s" ), locBase.c_str(), locfile.c_str() );
		PrintLn( err );
		wxCopyFile( locBase, locfile, false );
	}
	wxString baseviewdir = bindir;
	if ( baseviewdir.Last() != wxFileName::GetPathSeparator()) baseviewdir << wxFileName::GetPathSeparator();
	baseviewdir << wxT( "view" ) << wxFileName::GetPathSeparator();

	wxDir dir ( baseviewdir );
	wxString filename, target, filename2, targetdir;

	bool cont = dir.GetFirst(&filename, wxT( "*.view" ) );
	while ( cont )
	{
		target = viewdir;
		if ( target.Last() != wxFileName::GetPathSeparator()) target << wxFileName::GetPathSeparator();
		target << filename;

		if ( wxAccess( target.c_str(), F_OK ))
		{
			filename2.Clear();
			filename2 << baseviewdir << filename;
			err.Printf( wxT( "Copy file %s to %s" ), filename2.c_str(), target.c_str() );
			PrintLn( err );
			wxCopyFile( filename2, target, false );
		}
		cont = dir.GetNext(&filename);
	}
#endif
	initLanguage();
}

/*****************************************************
**
**   CLASS LangSorter
**
******************************************************/
class LangSorter
{
public:
	bool operator()( const LanguageEntry &l1, const LanguageEntry &l2 ) const
	{
		return l1.name.Cmp( l2.name ) < 0;
	}
};

/*****************************************************
**
**   Session   ---   initLanguage
**
******************************************************/
void Session::initLanguage()
{
	wxString s, err;
	wxStringTokenizer t( config->langList);
	list<LanguageEntry>::iterator iter;
	int theLang = -1;

#ifdef __WXMSW__
	bool found;
	// init langentries vector
	langentries.clear();
	langentries.push_back( LanguageEntry( wxLANGUAGE_ENGLISH_US, wxT( "en" ), _( "English" )));
	langentries.push_back( LanguageEntry( wxLANGUAGE_GERMAN, wxT( "de" ), _( "German" )));
	langentries.push_back( LanguageEntry( wxLANGUAGE_RUSSIAN, wxT( "ru" ), _( "Russian" )));
	langentries.push_back( LanguageEntry( wxLANGUAGE_TELUGU, wxT( "te" ), _( "Telugu" )));

	while( t.HasMoreTokens() )
	{
		s = t.GetNextToken();
		found = false;
		for( iter = langentries.begin(); iter != langentries.end(); iter++ )
		{
			if ((*iter).code == s )
			{
				found = true;
				break;
			}
		}
		if ( found == false )
		{
			const wxLanguageInfo *info = wxLocale::FindLanguageInfo( s );
			if ( info == 0 )
			{
				err.Printf( wxT( "Warning: unknown language %s" ), s.c_str());
				PrintLn( err );
			}
			else
			{
				langentries.push_back( LanguageEntry( info->Language, s, info->Description ));
			}
		}
	}
	langentries.sort( LangSorter() );
	const wxLanguageInfo *mylang = wxLocale::FindLanguageInfo( config->lang );
	if ( mylang != 0 )
	{
		for( iter = langentries.begin(); iter != langentries.end(); iter++ )
		{
			if ( (*iter).code == config->lang )
			{
				theLang = (*iter).wxId;
				break;
			}
		}
	}
	if ( theLang == -1 ) theLang = wxLANGUAGE_ENGLISH_US;
#else
	theLang = wxLANGUAGE_DEFAULT;
#endif
  //bool b =
	m_locale.Init( theLang );
  //if ( ! b ) printErr( "Error: Cannot set locale" );
	wxLocale::AddCatalogLookupPathPrefix( bindir );
  m_locale.AddCatalog( wxT( "maitreya" ));

	// Reinit names of langlist because list was set before locale init
	// New languages must be set manually
	for( iter = langentries.begin(); iter != langentries.end(); iter++ )
	{
		theLang = (*iter).wxId;
		switch( theLang )
		{
			case wxLANGUAGE_ENGLISH_US:
				(*iter).name = _( "English" );
			break;
			case wxLANGUAGE_GERMAN:
				(*iter).name = _( "German" );
			break;
			case wxLANGUAGE_RUSSIAN:
				(*iter).name = _( "Russian" );
			break;
			case wxLANGUAGE_TELUGU:
				(*iter).name = _( "Telugu" );
			break;
		}
	}

/*
	wxString localeInfo;
	wxString locale = m_locale.GetLocale();
	wxString sysname = m_locale.GetSysName();
	wxString canname = m_locale.GetCanonicalName();


	localeInfo.Printf(_("Language: %s\nSystem locale name:%s\nCanonical locale name: %s\n"),
	locale.c_str(), sysname.c_str(), canname.c_str() );
	PrintLn( localeInfo );
*/
}

/*****************************************************
**
**   Session   ---   getLocaleCode
**
******************************************************/
int Session::getLocaleCode()
{
	return m_locale.GetSystemLanguage();
}

/*****************************************************
**
**   Session   ---   setAppPath 
**
******************************************************/
void Session::setAppPath( const wxChar *path )
{
	wxPathList pl;
	pl.AddEnvList( wxT( "PATH" ));
	wxString exename  = pl.FindAbsoluteValidPath( path );

#ifndef __WXMSW__
  struct stat sb;
	char tmp[1024], filename[1024];
	int len, link_nb = 0;

	strcpy( tmp, wxConvertWX2MB( exename ));
  // test for a symbolic link
  if ( lstat( tmp, &sb ) == -1 )
  {
		printf( "Fatal Error: stat failed, errno is %d\n", errno );
    exit( 1 );
  }
  // maybe a recursive link
  while( S_ISLNK(sb.st_mode))
  {
    len = readlink( tmp, filename, 1024 );
    filename[len] = 0;
    strcpy( tmp, filename );
    if ( lstat( tmp, &sb ) == -1 )
    {
      printf( "Fatal Error: stat failed, errno is %d\n", errno );
      exit( 1 );
    }
    link_nb++;
    if ( link_nb > 1000 )
    {
      printf( "Fatal Error: to many recursive links, exiting" );
      exit( 1 );
    }
  }
	exename = wxConvertMB2WX( tmp );
#endif

	wxFileName fn( exename );
	bindir = fn.GetPath( exename );

#ifdef __WXMSW__
	configdir = bindir;
#endif
}

/*****************************************************
**
**   Session   ---   prepareConfigDir
**
******************************************************/
void Session::prepareConfigDir()
{
#ifndef __WXMSW__
	struct stat sb;
	wxString err;

	wxGetHomeDir(&configdir);
	if ( configdir.Last() != wxFileName::GetPathSeparator()) configdir << wxFileName::GetPathSeparator();
	configdir << wxT( ".maitreya4" );

  if ( ! wxAccess( configdir.c_str(), F_OK ))
  {
    if ( wxStat( configdir.c_str(), &sb ) == -1 )
    {
			err.Printf( wxT( "Fatal error: stat failed, errno is %d" ), errno );
			PrintLn( err );
      exit( 1 );
    }
    if( ! S_ISDIR(sb.st_mode))
    {
			err.Printf( wxT( "Fatal error: config directory %s found, but is not a directory" ), configdir.c_str() );
			PrintLn( err );
      exit( 1 );
    }
    if ( wxAccess( configdir.c_str(), W_OK ))
    {
			err.Printf( wxT( "Fatal error: config directory %s not writable" ), configdir.c_str() );
			PrintLn( err );
      exit( 1 );
    }
    if ( wxAccess( configdir.c_str(), X_OK ))
    {
			err.Printf( wxT( "Fatal error: config directory %s not listable" ), configdir.c_str() );
			PrintLn( err );
      exit( 1 );
    }
		//printf( "config dir found, nothing to do\n" );
  }
  else
  {
		err.Printf( wxT( "Creating config directory %s for the first time ..." ), configdir.c_str() );
		PrintLn( err );
    int error = wxMkdir( configdir.c_str(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH );
    if ( error == -1 )
    {
			err.Printf( wxT( "Fatal error: cannot create config directory %s" ), configdir.c_str() );
			PrintLn( err );
			exit( 1 );
    }
  }
	viewdir = configdir;
	if ( viewdir.Last() != wxFileName::GetPathSeparator()) viewdir << wxFileName::GetPathSeparator();
	viewdir  << wxT ( "view" );
  if ( wxAccess( viewdir.c_str(), F_OK ))
  {
		err.Printf( wxT( "Creating view directory %s for the first time ..." ), viewdir.c_str() );
		PrintLn( err );
		//int error =
		wxMkdir( viewdir.c_str(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH );
	}
	//else printf( "Viewdir found, nothing to do\n" );
#endif
}

/*****************************************************
**
**   Session   ---   getPicDir
**
******************************************************/
wxString Session::getPicDir()
{
	wxString s = bindir;
	if ( s.Last() != wxFileName::GetPathSeparator()) s << wxFileName::GetPathSeparator();
	s << wxT( "pics" );
	return s;
}

/*****************************************************
**
**   Session   ---   getPrintoutFile
**
******************************************************/
wxString Session::getPrintoutFile()
{
	wxString s = bindir;
	if ( s.Last() != wxFileName::GetPathSeparator()) s << wxFileName::GetPathSeparator();
	s << wxT( "printout.dat" );
	return s;
}

/*****************************************************
**
**   Session   ---   getLocationFile
**
******************************************************/
wxString Session::getLocationFile()
{
	wxString s = configdir;
	if ( s.Last() != wxFileName::GetPathSeparator()) s << wxFileName::GetPathSeparator();
	s << wxT( "locations.dat" );
	return s;
}

/*****************************************************
**
**   Session   ---   getLocationBackupFile
**
******************************************************/
wxString Session::getLocationBackupFile( const int &mode )
{
	wxChar buf[256];
	double jd;
	int day, month, year, hour, minute, second;
	Formatter *formatter = Formatter::get();
	wxString s = configdir;
	double tz;
	if ( s.Last() != wxFileName::GetPathSeparator()) s << wxFileName::GetPathSeparator();
	switch( mode )
	{
		case 0:
			s << wxT( "locations.dat" );
		break;
		case 1:
			s << wxT( "locations.bak" );
		break;
		case 2:
			tz = config->defaultLocation.getTimeZone() + config->defaultLocation.getDST();
			jd = JDate().getJD() + tz/24;
			formatter->getDateIntsFromJD( jd, day, month, year );
			formatter->getDegMinSecInts( getTimeFromJD( jd ), hour, minute, second );
			wxSprintf( buf, wxT( "locations%4d%02d%02d%02d%02d%02d.bak" ), year, month, day, hour, minute, second );
			s << buf;
		break;
		default:
			s << wxT( "locations.bak" );
		break;
	}
	return s;
}

/*****************************************************
**
**   Session   ---   getViewFilename
**
******************************************************/
wxString Session::getViewFilename( const wxString &viewname )
{
	wxString s = configdir;
	if ( s.Last() != wxFileName::GetPathSeparator()) s << wxFileName::GetPathSeparator();
	s << wxT( "view" ) << wxFileName::GetPathSeparator() << viewname << wxT( ".view" );
	return s;
}

/*****************************************************
**
**   Session   ---   getViewFilename
**
******************************************************/
vector<wxString> Session::getViewList()
{
	wxString filename;
	wxString viewdir = configdir;
	wxString viewname;
	vector<wxString> v;

	if ( viewdir.Last() != wxFileName::GetPathSeparator()) viewdir << wxFileName::GetPathSeparator();
	viewdir << wxT( "view" );
	wxDir dir( viewdir );
	bool cont = dir.GetFirst(&filename, wxT( "*.view" ), wxDIR_FILES );
	while ( cont )
	{
		viewname = filename.BeforeLast( '.' );
		v.push_back( viewname );
		cont = dir.GetNext(&filename);
	}
	return v;
}

/*****************************************************
**
**   Session   ---   clear 
**
******************************************************/
void Session::clear()
{
	if ( calculator ) delete calculator;
	calculator = 0;
	for( unsigned int i = 0; i < dasa_experts.size(); i++ ) delete dasa_experts[i];
	dasa_experts.clear();
}

/**************************************************************
***
** Session   ---   getVersion
***
***************************************************************/
wxString Session::getVersion()
{
	return wxT( VERSION );
}

/**************************************************************
***
** Session   ---   getDasaExpert
***
***************************************************************/
DasaExpert *Session::getDasaExpert( int i )
{
	if (( i < 0 ) || ( i >= (int)dasa_experts.size()))
	{
		wxLogError( wxT( "Error: Dasa Expert index out of range %d" ), i );
		return 0;
	}
	return dasa_experts[i];
}

/*****************************************************
**
**   Session   ---   getNoOfDasaExperts 
**
******************************************************/
int Session::getNoOfDasaExperts()
{
	return (int)dasa_experts.size();
}

/**************************************************************
***
** Session   ---   getCalculator
***
***************************************************************/
Calculator *Session::getCalculator()
{
	return (Calculator*)calculator;
}

/**************************************************************
***
** Session   ---   getGuiAppName
***
***************************************************************/
wxString Session::getGuiAppName()
{
	return wxT( "Maitreya" );
}

