/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Session.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _SESSION_H_
#define _SESSION_H_

#ifdef __GNUG__
	#pragma interface "Session.h"
#endif

#include "constants.h"
#include <wx/string.h>

#include <list>
#include <vector>

class Calculator;
class DasaExpert;
class wxLocale;

using namespace std;

/*****************************************************
**
**   CLASS LanguageEntry
**
******************************************************/
class LanguageEntry
{
public:
	LanguageEntry( const int &id, const wxString &langcode, const wxString &thename )
	{
		wxId = id;
		code = langcode;
		name = thename;
	}
	int wxId;
	wxString code;
	wxString name;
};

/*****************************************************
**
**   CLASS Session  
**
******************************************************/
class Session
{
public:

	static Session *get();
	void init( const wxChar* );
	~Session();
	void clear();

	// Encapsulation of DasaExpert access
	DasaExpert *getDasaExpert( int i );
	int getNoOfDasaExperts();

	// Encapsulation of Calculator access
	Calculator *getCalculator();

	// Version of the application
	wxString getVersion();

	// name of the application
	wxString getGuiAppName();

	wxString getPrintoutFile();
	wxString getLocationFile();
	wxString getLocationBackupFile( const int& mode );
	wxString getPicDir();
	wxString getBinDir() { return bindir; }
	wxString getConfigDir() { return configdir; }
	vector<wxString> getViewList();
	wxString getViewFilename( const wxString &viewname );
	list<LanguageEntry> getLanguages() { return langentries; }
	int getLocaleCode();
	wxLocale *getLocale() { return &m_locale; }

private:

	Session();
	static Session *ego;
	void setAppPath( const wxChar* );
	void prepareConfigDir();
	void initLanguage();
	vector<DasaExpert*> dasa_experts;
	Calculator *calculator;
	wxString configdir;
	wxString bindir;
	wxString viewdir;
  wxLocale m_locale;
	list<LanguageEntry> langentries;
};

#endif

