/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           SimpleHoroscope.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _SIMPLEHOROSCOPE_H_
#define _SIMPLEHOROSCOPE_H_

#ifdef __GNUG__
	#pragma interface "Midpoint.h"
#endif

#include "constants.h"
#include "DataSet.h"

class IPlanet;
class Varga;
class Writer;

/*****************************************************
**
**   CLASS PseudoHoroscope  
**
******************************************************/
class PseudoHoroscope
{
public:

	virtual ~PseudoHoroscope() {}
	//virtual double getObjectLength( const int& ) = 0;
	virtual bool isObjectRetrograde( const int &i ) = 0;
	virtual double getHouse( const int& housenb, const bool& vedic, const bool getsandhi = false ) = 0;
	virtual double getObjectLength( const int& ) = 0;

protected:
	//double object_len[MAX_BODIES], object_lat[MAX_BODIES], object_speed[MAX_BODIES], whousecusp[12], ihousecusp[12], ihousesandhi[12];

};

/*****************************************************
**
**   CLASS SimpleHoroscope  
**
******************************************************/
class SimpleHoroscope : public PseudoHoroscope
{
	friend class CompositHoroscope;
public:

	SimpleHoroscope();
	virtual ~SimpleHoroscope();
	void updatePlanets();
	void setDate( const int &day, const int &month, const int &year, const double &time ) { dataSet->setDate( day, month, year, time ); }
	void setDate( const double &jd ) { dataSet->setDate( jd ); }

	DataSet *getDataSet() { return dataSet; }
	Location *getLocation() { return dataSet->getLocation(); }
	void setActualDate() { dataSet->setActualDate(); }

	const wxChar *getHName() { return dataSet->getName(); }
	void setHName( const wxChar *name ) { dataSet->setName( name ); }

	const wxChar *getRemark() { return dataSet->getRemark(); }
	void setRemark( const wxChar *remark ) { dataSet->setRemark( remark ); }

	double getJD() const { return dataSet->getJD(); }
	void setLocation( const wxChar *locName, const double &longitude, const double &latitude, const double &tz, const double &dst )
		{ dataSet->setLocation( locName, longitude, latitude, tz, dst ); }
	void setLocation( const Location &l ) { dataSet->setLocation( l ); }

	bool openFile( const wxChar* );
	bool saveAs( const wxChar *filename );
	bool save();
	double getIAyanamsa() { return iayanamsa; }
	int getIAyanamsaType() { return iayanamsa_type; }
	double getWAyanamsa() { return wayanamsa; }
	int getWAyanamsaType() { return wayanamsa_type; }
	double getSiderealTime() { return siderealTime; }
	virtual double getObjectLength( const int& );
	virtual bool isObjectRetrograde( const int& );
	virtual double getHouse( const int& housenb, const bool& vedic, const bool getsandhi = false );
	int getHousePos( const int& planet );

	double getLongitude() { return dataSet->getLocation()->getLongitude(); }
	double getLatitude() { return dataSet->getLocation()->getLatitude(); }
	double getTimeZone() { return dataSet->getLocation()->getTimeZone(); }
	double getDST() { return dataSet->getLocation()->getDST(); }

	void writeAstronomicalData( Writer* );
	void writeBhavas( Writer *writer, const bool &vedic );

protected:
	FileDataSet *dataSet;
	double iayanamsa, wayanamsa, siderealTime;
	int iayanamsa_type, wayanamsa_type;
	double object_len[MAX_BODIES], object_lat[MAX_BODIES], object_speed[MAX_BODIES], whousecusp[12], ihousecusp[12], ihousesandhi[12];
};


#endif


