/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           TextWriter.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _TEXTWRITER_H_
#define _TEXTWRITER_H_

#ifdef __GNUG__
	#pragma interface "TextWriter.h"
#endif

#include "Writer.h"


/*****************************************************
**
**   CLASS TextWriter
**
******************************************************/
class TextWriter : public Writer
{
public:

	TextWriter();
	virtual ~TextWriter() {}
	virtual void beginWriting() { s.Clear(); }
	virtual void endWriting() {}
	virtual void writeHeader1( const wxString& );
	virtual void writeHeader2( const wxString& );
	virtual void writeHeader3( const wxString& );
	virtual void writeParagraph( const wxString& );
	virtual void writeLine( const wxString& );
	virtual void writeTable( Table& );
	virtual void writeListInColumns( const vector<wxString>, const int &colnr );
	virtual void writeMidpointDiagram( vector<MidpointDiagram> );

private:
	void writeEntry( const wxString &entry, const int &len );
	void writeMidpointDiagramPart( vector<MidpointDiagram> mp, const unsigned int &p1, const unsigned int &p2 );
};

#endif


