/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Varga.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _VARGA_H_
#define _VARGA_H_

#ifdef __GNUG__
	#pragma interface "Varga.h"
#endif

#include <wx/string.h>

#include "constants.h"

class Horoscope;
class VargaView;
class Writer;

/*****************************************************
**
**   CLASS Varga  
**
******************************************************/
class Varga
{
	friend class VargaExpert;
public:

	Varga( const int& index, const int &division );
	int getRasi() { return rasi; }
	double getBala() { return bala; }
	int getDivision() { return division; }
	double getLength() { return length; }

private:
	int rasi;
	double length;
	double bala;
	int division;
	int index;
};

/*****************************************************
**
**   CLASS Expert  
**
******************************************************/
class Expert
{
public:

	Expert();
	Expert( Horoscope* );
	Expert( VargaView* );
	virtual ~Expert() {}

	virtual void update() {}
	virtual void dump( wxString &o ) {}
	virtual void write( Writer* ) {}

protected:
	VargaView *view;
	Horoscope *horoscope;
};

/*****************************************************
**
**   CLASS VargaExpert  
**
******************************************************/
class VargaExpert : public Expert
{
public:

	VargaExpert() : Expert() {}
	VargaExpert( Horoscope *h ) : Expert( h ) {}
	int getNbVargas();
	const wxChar *getVargaName( const int & );
	const int getVargaDivision( const int& );
	void calcVarga( Varga *varga, const double& len, const int &vargaindex );
	int getVargaIndexByDivision( const int &d );
	void calcBala( const int &pindex, const double &len, const int &vindex );
	void calcShadVargas( Horoscope*, const int &planet, double &shadvarga, double &saptavarga, double &dasavarga,
		double &shodasavarga, double &dasamsa_avastha );
	virtual void write( Writer* );
	const static int vargaDivisions[NB_VARGAS];
	const wxString getDasamsAvastha( const int &i );

private:

};

/*****************************************************
**
**   CLASS VargaView  
**
******************************************************/
class VargaView
{
public:

	VargaView( const int div = 0 );
	VargaView( Horoscope*, const int division = 0 );
	VargaView( const VargaView &v );
	void setHoroscope( Horoscope* );
	Horoscope *getHoroscope() { return horoscope; }
	void setDivision( const int &division );
	int getDivision() { return division; }
	double getLength( const int &planet );
	double getRasiLength( const int &planet );
	int getRasi( const int &planet );
	int getBhava( const int &planet );
	double getCorrectedNakshatraLength( const double &len );
	int getNakshatra( const int &planet, const int &nsys );
	double getNakshatraLength( const int &planet, const int &nsys );
	bool isRetrograde( const int &planet );

private:

	Horoscope *horoscope;
	int division;
};

#endif


