/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ViewBuilder.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "ViewBuilder.h"
#endif

#include "ViewBuilder.h"

#include <assert.h>
#include <wx/string.h>
#include <math.h>
#include <unistd.h>
#include <sys/types.h>

#include "constants.h"
#include "Conf.h"
#include "Session.h"

extern int yydebug;
extern FILE *yyin;
extern int yyparse( void );

ViewContainer *viewcontainer;
extern Config *config;

//#define DEB_VIEWMODE_DESTRUCTORS
/*****************************************************
**
**   ViewNode   ---   Destructor 
**
******************************************************/
ViewNode::~ViewNode()
{
#ifdef DEB_VIEWMODE_DESTRUCTORS
	cout << "Destructor ViewNode" << Endl;
#endif
}

/*****************************************************
**
**   WidgetNode   ---   Constructor 
**
******************************************************/
WidgetNode::WidgetNode( ViewNode *p )
 : ViewNode( p )
{
	classid = subtype = 0;
	toolpanel = true;
	vedic = config->preferVedic;
}

/*****************************************************
**
**   WidgetNode   ---   Destructor 
**
******************************************************/
WidgetNode::~WidgetNode()
{
#ifdef DEB_VIEWMODE_DESTRUCTORS
	cout << "Destructor WidgetNode" << Endl;
#endif
}

/*****************************************************
**
**   WidgetNode   ---   dump 
**
******************************************************/
void WidgetNode::dump( wxString &o )
{
	o << wxT( "Start Widget" ) << Endl;
	o << wxT( "class " )  << classid << Endl;
	o << wxT( "subtype " ) << subtype << Endl;
	o << wxT( "toolpanel " ) << toolpanel << Endl;
	o << wxT( "Ende Widget" ) << Endl;
}

/*****************************************************
**
**   SplitterNode   ---   Destructor 
**
******************************************************/
SplitterNode::~SplitterNode()
{
#ifdef DEB_VIEWMODE_DESTRUCTORS
	cout << "Destructor SplitterNode" << Endl;
#endif
	if ( window1 ) delete window1;
	if ( window2 ) delete window2;
}

/*****************************************************
**
**   SplitterNode   ---   dump 
**
******************************************************/
void SplitterNode::dump( wxString &o )
{
	o << wxT( "Start Splitter Direction: " ) << dir << Endl;
	o << wxT( "saspos " ) << sashpos << Endl;
	o << wxT( "sasposrel " ) << sashpos_rel << Endl;
	if ( window1 ) window1->dump( o );
	else o << wxT( "Window1 empty" ) << Endl;
	if ( window2 ) window2->dump( o );
	else o << wxT( "Window2 empty" ) << Endl;
	o << wxT( "Ende Splitter" ) << Endl;
}

/*****************************************************
**
**   NotebookNode   ---   Destructor 
**
******************************************************/
NotebookNode::~NotebookNode()
{
#ifdef DEB_VIEWMODE_DESTRUCTORS
	cout << "Destructor NotebookNode window is " << window->getName() << Endl;
#endif
	unsigned int i;
	for( i = 0; i < pages.size(); i++ )
	{
		delete pages[i];
	}
	pages.clear();
}

/*****************************************************
**
**   NotebookNode   ---   dump 
**
******************************************************/
void NotebookNode::dump( wxString &o )
{
	unsigned int i;
	o << wxT( "NOTEBOOK -------- "  ) << Endl;
	for( i = 0; i < pages.size(); i++ )
	{
		o << Endl << wxT( "-------------------" ) << wxT( "Page No " ) << i+1 << Endl;
		pages[i]->dump( o );
	}
}

/*****************************************************
**
**   PageNode   ---   Destructor 
**
******************************************************/
PageNode::~PageNode()
{
#ifdef DEB_VIEWMODE_DESTRUCTORS
	cout << "Destructor PageNode window is " << window->getName() << Endl;
#endif
	if ( window ) delete window;
}

/*****************************************************
**
**   PageNode   ---   dump 
**
******************************************************/
void PageNode::dump( wxString &o )
{
	static int i = 0;
	if ( i++ > 10 ) exit(1);
	o << wxT( "Start Page " )
	<< name
	<< wxT( " window " )
	<< (int)window << Endl;
	if ( window ) window->dump( o );
	else o << wxT( "Page Empty" ) << Endl;
	o << wxT( "End Page" ) << Endl;
}

/*****************************************************
**
**   ViewContainer   ---   Destructor 
**
******************************************************/
ViewContainer::~ViewContainer()
{
#ifdef DEB_VIEWMODE_DESTRUCTORS
	cout << "Destructor ViewContainer" << Endl;
#endif
	if ( window ) delete window;
}

/*****************************************************
**
**   ViewContainer   ---   dump 
**
******************************************************/
void ViewContainer::dump( wxString &o )
{
	o << wxT( "CONTAINER -------- sizex " ) << sizex << wxT( " sizey " ) << sizey << Endl;
	o << wxT( "Description: " ) << description.c_str() << Endl;
	if ( window ) window->dump( o );
	else o << wxT( "Container Empty" ) << Endl;
}

/*****************************************************
**
**   ViewBuilder   ---   Constructor 
**
******************************************************/
ViewBuilder::ViewBuilder()
{
}

/*****************************************************
**
**   ViewBuilder   ---   getViewDefinition 
**
******************************************************/
bool ViewBuilder::getViewDefinition( ViewContainer *container, const wxChar *viewname )
{
	if ( ! viewname ) return false;
	wxString filename;
	wxString viewdir;
	wxString err;
	Session *session = Session::get();

	filename = session->getViewFilename( viewname );
	if ( wxAccess( filename, F_OK ))
	{
		err.Printf( wxT( "File %s not found" ), filename.c_str());
		PrintLn( err );
		return false;
	}
	if ( wxAccess( filename, R_OK ))
	{
		err.Printf( wxT( "File %s not readable" ), filename.c_str());
		PrintLn( err );
		return false;
	}

	viewcontainer = container;
#if wxUSE_UNICODE
	yyin = fopen( wxConvertWX2MB( filename.c_str() ), "r" );
#else
	yyin = fopen( filename.c_str(), "r" );
#endif

	if ( ! yyin ) return false;
	yyparse();
	fclose( yyin );
	//container->dump( cout );
	return true;
}

