/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ViewBuilder.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _VIEWBUILDER_H_
#define _VIEWBUILDER_H_

#ifdef __GNUG__
	#pragma interface "ViewBuilder.h"
#endif

#include <wx/gdicmn.h>
#include <wx/string.h>
#include <vector>

#include "constants.h"

class wxWindow;

using namespace std;

/*****************************************************
**
**   CLASS ViewNode  
**
******************************************************/
class ViewNode {
public:

	ViewNode( ViewNode *p ) { parent = p; size = wxDefaultSize; widget = 0; }
	virtual ~ViewNode();
	wxWindow *widget;

	ViewNode *parent;
	wxSize size;
	virtual bool isSplitterNode() { return false; }
	virtual bool isWidgetNode() { return false; }
	virtual bool isPageNode() { return false; }
	virtual bool isNotebookNode() { return false; }
	virtual bool isViewContainer() { return false; }
	virtual void dump( wxString& ) = 0;
	virtual const wxChar *getName() { return wxT( "ViewNode" ); }
};

/*****************************************************
**
**   CLASS WidgetNode  
**
******************************************************/
class WidgetNode : public ViewNode {
public:

	WidgetNode( ViewNode *p );
	virtual ~WidgetNode();

	virtual bool isWidgetNode() { return true; }
	int classid, subtype;
	bool toolpanel, vedic;
	virtual void dump( wxString& );
	virtual const wxChar *getName() { return wxT( "WidgetNode" ); }
};

/*****************************************************
**
**   CLASS SplitterNode  
**
******************************************************/
class SplitterNode : public ViewNode
{
public:

	SplitterNode( ViewNode *p ) : ViewNode( p ) { window1 = window2 = 0; dir = 0; sashpos = 200; sashpos_rel = 0; }
	virtual ~SplitterNode();

	virtual bool isSplitterNode() { return true; }
	ViewNode *window1, *window2;
	int dir, sashpos, sashpos_rel;
	virtual void dump( wxString& );
	virtual const wxChar *getName() { return wxT( "SplitterNode" ); }
};

/*****************************************************
**
**   CLASS PageNode  
**
******************************************************/
class PageNode : public ViewNode
{
public:

	PageNode( ViewNode *p ) : ViewNode( p ) { window = 0; name = wxT( "dummy" ); }
	virtual ~PageNode();
	virtual bool isPageNode() { return true; }
	ViewNode *window;
	wxString name;
	virtual void dump( wxString& );
	virtual const wxChar *getName() { return wxT( "PageNode" ); }
};

/*****************************************************
**
**   CLASS NotebookNode  
**
******************************************************/
class NotebookNode : public ViewNode
{
public:

	NotebookNode( ViewNode *p ) : ViewNode( p ) {}
	virtual ~NotebookNode();
	virtual bool isNotebookNode() { return true; }
	vector<PageNode*> pages;
	wxString name;
	virtual void dump( wxString& );
	virtual const wxChar *getName() { return wxT( "NotebookNode" ); }
};

/*****************************************************
**
**   CLASS ViewContainer  
**
******************************************************/
class ViewContainer : public ViewNode
{
public:

	ViewContainer() : ViewNode( 0 ) { sizex = sizey = 500; window = 0; }
	virtual ~ViewContainer();

	virtual bool isViewContainer() { return true; }
	wxString description;
	ViewNode *window;
	int sizex, sizey;
	virtual void dump( wxString& );
	virtual const wxChar *getName() { return wxT( "ViewContainer" ); }
};

/*****************************************************
**
**   CLASS ViewBuilder  
**
******************************************************/
class ViewBuilder
{
public:
	ViewBuilder();
	bool getViewDefinition( ViewContainer*, const wxChar* );

private:
};


#endif


