/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ViewBuilderLexer.ll
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

%option 8bit
%option yylineno

%{
#include<string.h>
#include "ViewBuilderParser.h"
//#include "y.tab.h"

%}

DIGIT   [0-9]+
IDENT   [A-Za-z0-9_/.]+
WS      [ 	]+
WSE      [ \t\n]*
%s COMMENT

%%

^[ \t]*"/*" { BEGIN COMMENT; }
^[ \t]*"/*".*"*/"[ \t]*\n  {}

<COMMENT>"*/"[ \t]*\n { BEGIN 0; }
<COMMENT>"*/" { BEGIN 0;  }
<COMMENT>\n {}
<COMMENT>.*\n {}

"//".*\n {}

\"[^"\n]*["\n] { yylval.sval = strdup( yytext ); return STRING; }

"container"  return CONTAINER;
"description"  return DESCRIPTION;
"page"  return PAGE;
"notebook"  return NOTEBOOK;
"class" return WIDGETCLASS;
"widget"  return WIDGET;
"splitter"  return SPLITTER;
"sashpos"  return SASHPOS;
"name" return NAME;
"size" return SIZE;
"split" return SPLIT;
"subtype" return SUBTYPE;
"vedic" return VEDIC;
"horizontal" { yylval.ival = 0; return SPLIT_DIRECTION; }
"vertical" { yylval.ival = 1; return SPLIT_DIRECTION; }
"toolpanel" return TOOLPANEL;
"true" { yylval.ival = 1; return BOOLEAN; }
"false" { yylval.ival = 0; return BOOLEAN; }

"GridView" { yylval.ival = 0; return VIEWTYPE; }
"GraphicView" { yylval.ival = 1; return VIEWTYPE; }
"YogaView" { yylval.ival = 2; return VIEWTYPE; }
"DasaView" { yylval.ival = 3; return VIEWTYPE; }
"TextView" { yylval.ival = 4; return VIEWTYPE; }
"SolarView" { yylval.ival = 5; return VIEWTYPE; }
"SbcView" { yylval.ival = 6; return VIEWTYPE; }
"GraphicalDasaView" { yylval.ival = 7; return VIEWTYPE; }
"MidpointView" { yylval.ival = 8; return VIEWTYPE; }
"TransitView" { yylval.ival = 9; return VIEWTYPE; }

"(" return LPAR;
")" return RPAR;

"{" return WLPAR;
"}" return WRPAR;

";" return SEMICOLON;
"," return COMMA;
"=" return EQ;
"%" return PERCENT;

{DIGIT} {
		yylval.ival = atoi( yytext );
		return DIGIT;
	}


{IDENT} {
		//cout << "IDENT in " << yylineno << " text " << yytext << Endl;
		yylval.sval = strdup( yytext );
		return IDENT;
	}

"#"[^\n]*"\n" {}

"\n"      {}

{WS}     {}


. {
		//cerr << "Error at line " << yylineno << " near token \"" << yytext << "\", exiting" << Endl;
		exit( 1 );
	}

%%
/**********************************************************
***
**   yywrap
***
**********************************************************/
int  yywrap( void )
{
	return( 1 );
}

