/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ViewBuilderParser.yy
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

%{

#include <stdio.h>
#include <stdlib.h>

#include "ViewBuilder.h"

using namespace std;

#define YYDEBUG 1
#define YYERROR_VERBOSE

int yyerror ( char* s);
extern int yylex( void );
extern int yylineno;
extern char *yytext;

extern ViewContainer *viewcontainer;
ViewNode *currentNode = 0;
void insertNode();

%}

%union {
  int ival;
	char *sval;
	double dval;
};

%token <ival> PAGE WIDGET SPLITTER EQ NAME WIDGETCLASS SIZE SASHPOS SPLIT HORIZONTAL VERTICAL VEDIC
%token <ival> LPAR RPAR WLPAR WRPAR SEMICOLON COMMA DIGIT SPLIT_DIRECTION VIEWTYPE SUBTYPE CONTAINER
%token <ival> TOOLPANEL BOOLEAN TRUE FALSE NOTEBOOK DESCRIPTION PERCENT
%token <sval> IDENT STRING

%%

container : CONTAINER { currentNode = viewcontainer; }
	WLPAR container_def_list WRPAR SEMICOLON
;

container_def_list : container_def | container_def container_def_list;
container_def : container_size | container_description | view;

container_size : SIZE EQ LPAR DIGIT COMMA DIGIT RPAR SEMICOLON
	{
		viewcontainer->sizex = $4;
		viewcontainer->sizey = $6;
	}
;

container_description : DESCRIPTION EQ STRING SEMICOLON
	{
		yylval.sval[ strlen( yylval.sval )-1] = 0;
		viewcontainer->description = wxConvertMB2WX( yylval.sval+1 );
	}
;

view : widget | splitter | notebook;

notebook : NOTEBOOK
	{
    currentNode = new NotebookNode( currentNode );
		insertNode();
	}
	WLPAR notebook_page_list WRPAR SEMICOLON
	{
		currentNode = currentNode->parent;
	}
;

notebook_page_list : notebook_page | notebook_page_list notebook_page;

notebook_page : PAGE
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "NotebookNode" ))) YYERROR;
		NotebookNode *nn = (NotebookNode*)currentNode;
		currentNode = new PageNode( nn );
		nn->pages.push_back( (PageNode*)currentNode );
	}
	WLPAR page_def_list WRPAR SEMICOLON
	{
		currentNode = currentNode->parent;
	}
;
 
page_def_list : page_def | page_def_list page_def;
page_def : page_name | view;

page_name : NAME EQ STRING SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "PageNode" ))) YYERROR;
		yylval.sval[ strlen( yylval.sval )-1] = 0;
		((PageNode*)currentNode)->name = wxConvertMB2WX( yylval.sval+1 );
	}
;

widget : WIDGET { currentNode = new WidgetNode( currentNode ); }
	WLPAR widget_def_list WRPAR SEMICOLON
	{
		insertNode();
		currentNode = currentNode->parent;
	};

widget_def_list : widget_def | widget_def_list widget_def;
widget_def : widget_class | widget_subtype | widget_toolpanel | widget_vedic;

widget_class: WIDGETCLASS EQ VIEWTYPE SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "WidgetNode" )))
			yyerror( "Syntax Error: widget class declaration not inside widget" );
		((WidgetNode*)currentNode)->classid = yylval.ival;
	}
;

widget_subtype: SUBTYPE EQ DIGIT SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "WidgetNode" )))
			yyerror( "Syntax Error: widget size declaration not inside widget" );
		((WidgetNode*)currentNode)->subtype = $3;
	}
;

widget_vedic: VEDIC EQ BOOLEAN SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "WidgetNode" )))
			yyerror( "Syntax Error: widget size declaration not inside widget" );
		((WidgetNode*)currentNode)->vedic = $3;
	}
;
widget_toolpanel: TOOLPANEL EQ BOOLEAN SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "WidgetNode" )))
			yyerror( "Syntax Error: toolpanel declaration not inside widget" );
		((WidgetNode*)currentNode)->toolpanel = $3;
	}
;

splitter : SPLITTER { currentNode = new SplitterNode( currentNode ); }
	WLPAR splitter_def_list WRPAR SEMICOLON
	{
		insertNode();
		currentNode = currentNode->parent;
	}
;

splitter_def_list : splitter_def | splitter_def_list splitter_def;
splitter_def : widget | splitter | splitter_sash | splitter_sash_rel | splitter_dir;

splitter_sash : SASHPOS EQ DIGIT SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "SplitterNode" )))
			yyerror( "Sashpos command only allowed in SplitterNode" );
		((SplitterNode*)currentNode)->sashpos = $3;
	}
;

splitter_sash_rel : SASHPOS EQ DIGIT PERCENT SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "SplitterNode" )))
			yyerror( "Sashpos command only allowed in SplitterNode" );
		((SplitterNode*)currentNode)->sashpos_rel = $3;
	}
;

splitter_dir : SPLIT EQ SPLIT_DIRECTION SEMICOLON
	{
		if ( wxStrcmp( currentNode->getName(), wxT( "SplitterNode" )))
			yyerror( "Split command only allowed in SplitterNode" );
		((SplitterNode*)currentNode)->dir = yylval.ival;
	}
;

%%

void insertNode()
{
	/*
	if ( ! wxStrcmp( currentNode->parent->getName(), wxT( "ViewContainer" )))
	{
		ViewContainer *vv = (ViewContainer*)currentNode->parent;
	}
	*/
	ViewNode *node = currentNode->parent;
	if ( ! node ) yyerror( "Syntax Error: parent node empty" );
	if ( node && node->isSplitterNode() )
	{
		SplitterNode *sn = (SplitterNode*)node;
		if ( ! sn->window1 ) sn->window1 = currentNode;
		else if ( ! sn->window2 ) sn->window2 = currentNode;
		else yyerror( "Syntax Error: all splitter subnodes already occupied" );
	}
	else if ( node && node->isPageNode() )
	{
		PageNode *pn = (PageNode*)node;
		if ( ! pn->window ) pn->window = currentNode;
		else yyerror( "Syntax Error: pages has already a window" );
	}
	else if ( node && node->isViewContainer() )
	{
		ViewContainer *cn = (ViewContainer*)node;
		if ( ! cn->window ) cn->window = currentNode;
		else yyerror( "Syntax Error: container has already a window" );
	}
	else yyerror( "Syntax Error: wrong node type for view insert" );
}

int yyerror ( char* s)
{
	fprintf( stderr, "Error at line %d near token %s (message: %s)\n", yylineno, yytext, s );
	exit(1);
}

