/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           VimsottariDasa.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "VimsottariDasa.h"
#endif

#include "VimsottariDasa.h"

#include <assert.h>

#include "Calculator.h"
#include "IPlanet.h"
#include "Horoscope.h"
#include "Dasa.h"
#include "func.h"
#include "Lang.h"
#include "Session.h"


/*****************************************************
**
**   LagnaVimsottariDasaExpert   ---   getPortion 
**
******************************************************/
double LagnaVimsottariDasaExpert::getPortion( Horoscope *h, int &nak )
{
	Calculator *calculator = Session::get()->getCalculator();
	double mlen = h->getObjectLength( IASCENDANT );
	nak = (int)( mlen / NAKSHATRA_LEN );
	return calculator->calcAscendantPortion( h->getDataSet(), h->getObjectLength( IASCENDANT ));
}

/*****************************************************
**
**   VimsottariBaseDasaExpert   ---   getDasaLordByIndex
**
******************************************************/
int VimsottariBaseDasaExpert::getDasaLordByIndex( const int &i )
{
	static const int dasa_lord[9] = { ISUN, IMOON, IMARS, IRAHU, IJUPITER, ISATURN, IMERCURY, IKETU, IVENUS };
	assert( i >= 0 && i < 9 );
	return dasa_lord[i];
}

/*****************************************************
**
**   VimsottariBaseDasaExpert   ---   getDasaIndex4Nakshatra
**
******************************************************/
int VimsottariBaseDasaExpert::getDasaIndex4Nakshatra( const int &nak )
{
	int pindex = ( nak + 7 ) % 9;
	return pindex;
}

/*****************************************************
**
**   VimsottariBaseDasaExpert   ---   getDasaDuration
**
******************************************************/
int VimsottariBaseDasaExpert::getDasaDuration( const int &i )
{
	static const int dasa_dur[9] = { 6, 10, 7, 18, 16, 19, 17, 7, 20  };
	assert( i >= 0 && i < 9 );
	return dasa_dur[i];
}




