/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           VimsottariDasa.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _VIMSOTTARIDASA_H_
#define _VIMSOTTARIDASA_H_

#ifdef __GNUG__
	#pragma interface "VimsottariDasa.h"
#endif

#include "constants.h"
#include "GenericDasa.h"
#include <vector>

class Horoscope;
using namespace std;


/*****************************************************
**
**   CLASS VimsottariBaseDasaExpert  
**
******************************************************/
class VimsottariBaseDasaExpert : public GenericNakshatraDasaExpert
{
public:
protected:
	virtual int getNbLords() { return 9; }
	virtual int getTotalLength() { return 120; }
	virtual int getDasaLordByIndex( const int& );
	virtual int getDasaIndex4Nakshatra( const int& );
	virtual int getDasaDuration( const int& );

private:
};

/*****************************************************
**
**   CLASS VimsottariDasaExpert  
**
******************************************************/
class VimsottariDasaExpert : public VimsottariBaseDasaExpert
{
public: 
	virtual const wxChar *getName() { return _( "Vimsottari" ); }

protected:
};

/*****************************************************
**
**   CLASS LagnaVimsottariDasaExpert  
**
******************************************************/
class LagnaVimsottariDasaExpert : public VimsottariBaseDasaExpert
{
public: 
	virtual const wxChar *getName() { return  _( "Lagna Vimsottari" ); }

protected:
	// owerwrites Moon based calculation
	virtual double getPortion( Horoscope *h, int &nak );
};

#endif

