/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Writer.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "Writer.h"
#endif

#include "Writer.h"

/*****************************************************
**
**   Row   ---   isEmpty
**
******************************************************/
bool Row::isEmpty()
{
	for( unsigned int i = 0; i < value.size(); i++ )
	{
		if ( value[i].value != wxEmptyString || value[i].isHeader ) return false;
	}
	return true;
}

/*****************************************************
**
**   Table   ---   Constructor 
**
******************************************************/
Table::Table( const unsigned int &cols, const unsigned int &rows )
{
	unsigned int r, c;

	nb_rows = rows;
	nb_cols = cols;
	for( c = 0; c < cols; c++ )
	{
		col_width.push_back( 0 );
		col_alignment.push_back( TABLE_ALIGN_LEFT );
		col_line.push_back( false );
		col_empty.push_back( true );
		col_break.push_back( false );
	}
	for( r = 0; r < rows; r++ )
	{
		contents.push_back( Row());
		for( c = 0; c < cols; c++ )
		{
			//contents[r].value.push_back( TableEntry( wxT( "-" )));
			contents[r].value.push_back( TableEntry( wxEmptyString ));
		}
	}
	//printf ( "Finished table with %d cols and %d rows\n", nb_cols, nb_rows );
}

/*****************************************************
**
**   Table   ---   setHeader
**
******************************************************/
void Table::setHeader( const unsigned int &col, const wxString &s1 )
{
	contents[0].value[col] = TableEntry( s1, true );
}

/*****************************************************
**
**   Table   ---   setHeaderEntry
**
******************************************************/
void Table::setHeaderEntry( const unsigned int&col, const unsigned int &row, const wxString &s1 )
{
	//printf( "Set header entry col %d \n", col );
	contents[row].value[col] = TableEntry( s1, true );
	if ( col_empty[col] &&  s1 != wxEmptyString )
	{
		col_empty[col] = false;
	}
}

/*****************************************************
**
**   Table   ---   setEntry
**
******************************************************/
void Table::setEntry( const unsigned int &col, const unsigned int &row, const wxString &s1 )
{
	if ( col_empty[col] &&  s1 != wxEmptyString ) col_empty[col] = false;
	contents[row].value[col] = TableEntry( s1, false );
}

/*****************************************************
**
**   Writer   ---   writeCredits
**
******************************************************/
void Writer::writeCredits()
{
	writeLine( wxT( "Thanks to all contributors!  Special thanks to the" ));
	writeHeader3( wxT( "Translators" ));
	writeParagraph( wxT( "Eugeny Ostapenko, amigo-at-mail66.ru (Russian translation)" ));
	writeLine( wxT( "Santhosh Kumar Sharma Gollapell, astrosanthosh-at-yahoo.com, http://www.onlinejyotish.com (Telugu translation)" ));

	writeHeader3( wxT( "Software" ));
	writeParagraph( wxT( "Swiss Ephemeris: http://www.astro.com: framework for astronomical calculation." ));
	writeParagraph( wxT( "wxWidgets: http://www.wxWidgets.org: platform independent Gui Toolkit." ));
	writeParagraph( wxT( "OpenGeoDB: http://www.opengeodb.de: data for location database." ));
	writeParagraph( wxT( "Sourceforge: http://sf.net: download hosting." ));
}

