/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Writer.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _WRITER_H_
#define _WRITER_H_

#ifdef __GNUG__
	#pragma interface "Writer.h"
#endif

#include <wx/string.h>
#include <vector>

#include "constants.h"

using namespace std;

/*****************************************************
**
**   CLASS TableEntry
**
******************************************************/
class TableEntry
{
public:
	TableEntry() { value = wxT( "" ); isHeader = false; height = width = 0; }
	TableEntry( const wxString &v, const bool header = false ) { value = v; isHeader = header; }
	wxString value;
	int height, width;
	bool isHeader;
};

/*****************************************************
**
**   CLASS Row
**
******************************************************/
class Row
{
public:
	Row() { max_height = 0; }
	vector<TableEntry> value;
	int max_height;
	bool isEmpty();
};

enum { TABLE_ALIGN_LEFT = 0, TABLE_ALIGN_CENTER, TABLE_ALIGN_RIGHT };

/*****************************************************
**
**   CLASS Table
**
******************************************************/
class Table
{
public:
	Table( const unsigned int &cols, const unsigned int &rows );
	void setHeader( const unsigned int &col, const wxString& );
	void setHeaderEntry( const unsigned int&col, const unsigned int &row, const wxString& );
	void setEntry( const unsigned int &col, const unsigned int &row, const wxString& );
	unsigned int nb_rows, nb_cols;
	vector<Row> contents;
	vector<int> col_width;
	vector<int> col_alignment;
	vector<bool> col_line; // what's that?
	vector<bool> col_empty;
	vector<bool> col_break;

protected:
};

/*****************************************************
**
**   CLASS MidpointDiagramEntry
**
******************************************************/
class MidpointDiagramEntry
{
public:
	MidpointDiagramEntry( wxString pp1, wxString pp2 ) { p1 = pp1; p2 = pp2; }
	wxString p1, p2;
};

/*****************************************************
**
**   CLASS MidpointDiagram
**
******************************************************/
class MidpointDiagram
{
public:
	wxString master;
	vector<MidpointDiagramEntry> entries;
};


/*****************************************************
**
**   CLASS Writer  
**
******************************************************/
class Writer
{
public:

	virtual ~Writer() {} 
	virtual void beginWriting() = 0;
	virtual void endWriting() = 0;
	virtual void writeHeader1( const wxString& ) = 0;
	virtual void writeHeader2( const wxString& ) = 0;
	virtual void writeHeader3( const wxString& ) = 0;
	virtual void writeParagraph( const wxString& ) = 0;
	virtual void writeLine( const wxString& ) = 0;
	virtual void writeListInColumns( const vector<wxString>, const int &colnr ) = 0;
	//Table createTable( const int &cols, const int &rows ) = 0;
	virtual void writeTable( Table& ) = 0;
	virtual void writeMidpointDiagram( vector<MidpointDiagram> ) = 0;
	wxString getContents() { return s; }
	void writeCredits();
	int type;

protected:
	wxString s;
};

#endif


