/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           WriterFactory.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "WriterFactory.h"
#endif

#include "WriterFactory.h"
#include "HtmlWriter.h"
#include "constants.h"
#include "TextWriter.h"
#include "Writer.h"


/*****************************************************
**
**   WriterFactory   ---   getWriter
**
******************************************************/
Writer *WriterFactory::getWriter( const int& type )
{
	Writer *writer = 0;
	switch( type )
	{
		case WRITER_TEXT:
			writer = new TextWriter();
		break;
		case WRITER_HTML:
			writer = new HtmlWriter();
		break;
		default:
			assert( false );
		break;
	}
	return writer;
}

