/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           constants.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _CONSTANTS_H_
#define _CONSTANTS_H_

#include <wx/intl.h>

/*
 make it run under wx 2.4
*/
#if wxMINOR_VERSION == 4  && wxMAJOR_VERSION == 2
#define wxFIXED_MINSIZE 0
#define WX_VERSION24
#endif

/**************************************************************
***
** I18N
***
***************************************************************/
#ifdef __WXMSW__
#define Endl wxT( "\r\n" )
#else
#define Endl wxT( "\n" )
#endif

//#define FILE_CONF_MODE wxConvISO8859_1
#define FILE_CONF_MODE wxConvUTF8

#if wxUSE_UNICODE
#define Cout( s ) printf( wxConvertWX2MB(s) );
#else
#define Cout( s ) printf( s );
#endif
#define PrintLn( s ) Cout( s ); printf( "\n" );

/**************************************************************
***
**  VARIOUS CONSTANTS
***
***************************************************************/
#define CALC_NO_UT 0
#define CALC_UT 1

#define YEAR_LEN 365.25;
#define ICUSTOM_YEAR_LEN 365.25f;
#define WCUSTOM_YEAR_LEN 362.83f;

// That's PI 
#define PI 3.14159265358979323846

// Constants for transformations deg <=> rad
#define DEG2RAD 0.0174532925199433
#define RAD2DEG 57.2957795130823

// Should increase one day
#define MAXLANG 2

// Just 3 ayanamsas now, deleted the awkful ones
#define NB_AYANAMSAS 3
#define DEFAULT_T0 2415020.0
#define DEFAULT_AYAN_T0 22.46047
#define DEFAULT_AYA_PERIOD 25771.4021

// A wrong line feed may look ugly on Windows and Unix
#ifdef __WXMSW__
#define LINE_FEED wxT( "\r\n" )
#else
#define LINE_FEED wxT( "\n" )
#endif

// Should be  known, but tell the compiler if not
#ifndef Min
#define Min( a, b ) ( a < b ? a : b )
#endif
#ifndef Max
#define Max( a, b ) ( a > b ? a : b )
#endif

// Needed for config file/registry
#define APP_NAME wxT( "maitreya" )
#define VENDOR_NAME wxT( "Saravali" )

// AboutDialog
#define AUTHOR wxT( "Martin Pettau" )
#define URL wxT( "http://www.saravali.de" )

enum { WRITER_TEXT, WRITER_HTML, WRITER_PDF };

/**************************************************************
***
**  PLANETARY OBJECTS -- very sensitive constants !
***
***************************************************************/
//#define MAX_NAMED_OBJECTS 51
#define MAX_NAMED_OBJECTS 45
enum { ISUN = 0, IMOON, IMARS, IMERCURY, IJUPITER, IVENUS, ISATURN, IRAHU, IKETU, IASCENDANT, // upto 10
	IBHAVA_LAGNA, IHORA_LAGNA, IGHATIKA_LAGNA, // upto 13
	IDHUMA, IVYATIPATA, IPARIVESHA, ICHAPA, IUPAKETU, IKALA, IMRITYU, IARDHAPRAHARA, IYAMAGHANTAKA, IGULIKA, // upto 23
	WSUN, WMOON, WMERCURY, WVENUS, WMARS, WJUPITER, WSATURN, WURANUS, WNEPTUNE, WPLUTO, WLUNARNODE,
	WASCENDANT, WMC, // upto 36
	WCUPIDO, WHADES, WZEUS, WKRONOS, WAPOLLON, WADMETOS, WVULKANUS, WPOSEIDON, WARIES//, // upto 45
	//WCHEIRON, WCERES, WPALLAS, WJUNO, WVESTA, WPHOLUS
};

// Numbers of upagrahas and special lagnas
#define NUM_UPA 10
#define NUM_LAGNA 3

#define MAX_IOBJECTS                 13  // including nodes and ascendant
#define MAX_IOBJECTS_LAGNA           13  // plus special lagnas
#define MAX_IOBJECTS_LAGNA_UPA       23  // plus upagrahas
#define MAX_IOBJECTS_LAGNA_UPA_BHAVA 35  // plus 12 bhavas

// Astronomical view of bodies
#define MAX_BODIES 23
//#define MAX_BODIES 29
enum { OSUN = 0, OMOON, OMERCURY, OVENUS, OMARS, OJUPITER, OSATURN, // upto 7
	OURANUS, ONEPTUNE, OPLUTO, OMEANNODE, OTRUENODE, // upto 12
	OCUPIDO, OHADES, OZEUS, OKRONOS, OAPOLLON, OADMETOS, OVULKANUS, OPOSEIDON, OARIES, OASCENDANT, OMC//, // upto 23
	//OCHEIRON, OCERES, OPALLAS, OJUNO, OVESTA, OPHOLUS
};

// Virtual bodies
enum { OBHAVA_LAGNA = 0, OHORA_LAGNA, OGHATIKA_LAGNA };
enum { ODHUMA = 0, OVYATIPATA, OPARIVESHA, OCHAPA, OUPAKETU, OKALA, OMRITYU, OARDHAPRAHARA, OYAMAGHANTAKA, OGULIKA };

// indices for houses, so we don't ge confused when counting them
enum { HOUSE1 = 0, HOUSE2, HOUSE3, HOUSE4, HOUSE5, HOUSE6, HOUSE7, HOUSE8, HOUSE9, HOUSE10, HOUSE11, HOUSE12 };

#define HOUSE_SYS_NUM 13
enum { HOUSE_SYSTEM_NONE = 0, HOUSE_SYSTEM_PLACIDUS, HOUSE_SYSTEM_KOCH, HOUSE_SYSTEM_REGIOMONTANUS,
	HOUSE_SYSTEM_CAMPANUS, HOUSE_SYSTEM_PORPHYRY, HOUSE_SYSTEM_EQUAL, HOUSE_SYSTEM_VEHLOW, HOUSE_SYSTEM_AXIAL,
	HOUSE_SYSTEM_AZIMUTAL, HOUSE_SYSTEM_POLICH, HOUSE_SYSTEM_ALCABITUS, HOUSE_SYSTEM_MORINUS };

// Zodiacal signs, second seems to be not used
enum { ARIES = 0, TAURUS, GEMINI, CANCER, LEO, VIRGO, LIBRA, SCORPIO, SAGITTARIUS, CAPRICORNUS, AQUARIUS, PISCES };
enum { MESHA = 0, VRISHABA, MITHUNA, KARKA, SIMHA, KANJA, TULA, VRISHIKA, DHANUSH, MAKARA, KUMBHA, MINA };

/**************************************************************
***
**  WINDOW STYLES
***
***************************************************************/
// Graphic Styles
#define IGRAPHIC_STYLE_EAST_INDIAN         0x01 // 1
#define IGRAPHIC_STYLE_NORTH_INDIAN        0x02 // 2
#define IGRAPHIC_STYLE_SOUTH_INDIAN        0x04 // 4
#define IGRAPHIC_STYLE_NAKSHATRA           0x08 // 8
#define IGRAPHIC_STYLE_SHOW_ARUDHAS        0x10 // 16
#define IGRAPHIC_STYLE_SHOW_SPECIAL_LAGNAS 0x20 // 32
#define IGRAPHIC_STYLE_SHOW_RETRO          0x40 // 64
#define IGRAPHIC_STYLE_SHOW_DEGRESS        0x80 // 128

#define WGRAPHIC_STYLE_SHOW_HOUSES         0x01 // 1
#define WGRAPHIC_STYLE_SHOW_ASPECTS        0x02 // 2
#define WGRAPHIC_STYLE_SHOW_RETRO          0x04 // 4
#define WGRAPHIC_STYLE_SHOW_DEGREES        0x08 // 8
#define WGRAPHIC_STYLE_SHOW_URANIAN        0x10 // 16

#define IMAIN_CHILD_SHOW_NAVAMSA      0x001
#define IMAIN_CHILD_SHOW_KARAKA       0x002
#define IMAIN_CHILD_SHOW_SHASTIAMSA   0x004
#define IMAIN_CHILD_SHOW_NAKSHATRA    0x008
#define IMAIN_CHILD_SHOW_DASAVARGA    0x010
#define IMAIN_CHILD_SHOW_BHAVA        0x020
#define IMAIN_CHILD_SHOW_KP           0x040
#define IMAIN_CHILD_SHOW_LAGNAS       0x080
#define IMAIN_CHILD_SHOW_UPA          0x100
#define IMAIN_CHILD_SHOW_ASHTAKA      0x200
#define IMAIN_CHILD_SHOW_PADA         0x400
#define IMAIN_CHILD_SHOW_HOUSES       0x800

#define WMAIN_CHILD_SHOW_URANIAN      0x001
#define WMAIN_CHILD_SHOW_HOUSES       0x002
#define WMAIN_CHILD_SHOW_HOUSEPOS     0x004

// Text styles for planets, etc
enum { TSHORT = 0, TMEDIUM, TLARGE };

// Text Window
enum { TBASE = 0, TINDIAN, TWESTERN, TNAKSHATRA, TVARGA, TASPECTS, TASHTAKAVARGA, TKP, TJAIMINI, TDASA,
  TDASALONG, TBHAVA, TASTRONOMICAL };

/**************************************************************
***
**  VEDIC ASTROLOGY
***
***************************************************************/
// Karakas of Jaimini Astrology
enum { ATMA_KARAKA, AMATYA_KARAKA, BHRATRU_KARAKA, MATRU_KARAKA, PITRU_KARAKA, PUTRA_KARAKA, GNATI_KARAKA, DARA_KARAKA };

// Varga Options - not in config dialog, does anyone need that?
enum { HORA_PARASARA, HORA_JAGANNATH, HORA_PARIVRITTIDVAYA };
enum { DREKKANA_PARASARA, DREKKANA_JAGANNATH, DREKKANA_PARIVRITTITRAYA, DREKKANA_SOMNATH };

enum { TEXT_STYLE_INDIAN, TEXT_STYLE_WESTERN }; // What's that?

enum { DASA_TYPE_NONE = -1, DASA_TYPE_NAKSHATRA, DASA_TYPE_PLANET, DASA_TYPE_SIGN };
enum { LUNAR_NODE_TRUE = 0, LUNAR_NODE_MEAN };

enum { VARNA_KSHATRIYA = 0, VARNA_VAISHYA, VARNA_SHUDRA, VARNA_BRAHMIN };
enum { GANA_DEVA = 0, GANA_MANUJ, GANA_RAKSHAS };
enum { NADI_AADI = 0, NADI_MADHYA, NADI_ANTYA };
enum { VASHYA_QUADRUPED, VASHYA_HUMAN, VASHYA_JALACHARA, VASHYA_LEO, VASHYA_SCORPIO };

// Nakshatra stuff
enum {
	ASWINI = 0, BHARANI, KRITTIKA, ROHINI, MRIGASIRA, ARUDRA, PUNARVASU, PUSHYAMI, ASLESHA,
	MAKHA, PPHALGUNI, UPHALGUNI, HASTHA, CHITTA, SWATI, VISAKHA, ANURADHA, JYESHTA,
	MULA, PSHADHA, USHADHA, ABHIJIT, SRAVANA, DHANISHTA, SATHABISHAK, PBHADRA, UBHADRA, REVATI
};

enum {
	NASWINI = 0, NBHARANI, NKRITTIKA, NROHINI, NMRIGASIRA, NARUDRA, NPUNARVASU, NPUSHYAMI, NASLESHA,
	NMAKHA, NPPHALGUNI, NUPHALGUNI, NHASTHA, NCHITTA, NSWATI, NVISAKHA, NANURADHA, NJYESHTA,
	NMULA, NPSHADHA, NUSHADHA, NSRAVANA, NDHANISHTA, NSATHABISHAK, NPBHADRA, NUBHADRA, NREVATI
};

#define NAKSHATRA_LEN 13.33333333333
#define NAKSHATRA_LEN_R 13.33333333333 // 360 / 27
#define NAKSHATRA_LEN_N 12.85714286    // 360/28
#define N27_N28_RATIO .964285714       // 27/28
#define N28_N27_RATIO 1.037037037      // 28/27
#define PADA_LEN 3.333333333333

#define USHADHA_BEGIN_R 266.6666666667
#define ABHIJIT_BEGIN_R 276.6666666667
#define SRAVANA_BEGIN_R 280.8888888889
#define DHANISHTA_BEGIN_R 293.6666666667

#define USHADHA_LEN_R 10
#define ABHIJIT_LEN_R 4.2222222222 // = 4:13:20;
#define SRAVANA_LEN_R 12.444444444 // = 12:26:40
enum { N27 = 0, N28 };  // Normal /old fashioned / learned

// Exaltation points
const int k_exaltation[9] = { 10, 33, 298, 165, 95, 357, 200, 285, 225 };

#define NB_VARGAS 19

// Friends and Enemies
enum { ENEMY = 0, NEUTRAL, FRIEND };

// Shastiamsa - 10 in each line
const bool k_shastiamsa_benefic[60] = {
	false, false, true, true, true, true, false, false, false, false,
	false, false, true, true, false, false, true, true, true, true,
	true, true, true, true, true, true, true, true, true, false,
	false, false, false, false, false, false, true, true, true, false,
	false, false, false, false, true, true, true, false, true, true,
	false, false, true, true, false, true, true, true, false, true,
};

// Dasas
enum { DASA_VIMSOTTARI = 0, DASA_YOGINI, DASA_KALACHAKRA, DASA_ASHTOTTARI, DASA_SHODSHOTTARI,
	DASA_DVADASHOTTARI, DASA_PANCHOTTARI, DASA_SHATABDIKA, DASA_CHATURASHITISAMA,
	DASA_DVISAPTATISAMA, DASA_SHATTRIMSATSAMA, DASA_LAGNAVIMSOTTARI,
	DASA_SHULA, DASA_SHULA39, DASA_SHULA410, DASA_SHULA511 };

/**************************************************************
***
**  Midpoint astrology
***
***************************************************************/
enum { GRADKREIS_360 = 0, GRADKREIS_180, GRADKREIS_90, GRADKREIS_45, GRADKREIS_225, GRADKREIS_1125, GRADKREIS_5625  };
enum { TREFFER_360 = 1, TREFFER_180, TREFFER_90, TREFFER_45, TREFFER_225, TREFFER_1125, TREFFER_5625 };

#endif


