/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           func.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef _FUNC_H_
#define _FUNC_H_

#ifdef __GNUG__
	#pragma interface "func.h"
#endif

#include "constants.h"

/**************************************************************
***
**  Functions for circular periods
***
***************************************************************/
double a_red( const double &x, const double &a ); // mod a
double red_deg( const double &input );            // mod 360
double red_rad( const double &input );            // mod 2*PI
int red12( const int &input );                    // mod 12 (integer)

/**************************************************************
***
** print something to the console, unicode enabled
***
***************************************************************/
void printNl();
void printStr( const char *s );
void printErr( const char *s );
void printErrAndExit( const char *s, const int code = 1 );
void printEl();

/**************************************************************
***
**  Variuos mathematical funtions
***
***************************************************************/
wxString locateFile( const wxString &file );
double calcYearLength( const int sel, const bool vedic );
void getRgbValues( const int &color, unsigned char &red, unsigned char &green, unsigned char &blue );
void getRgbString( wxChar *buf, const int &color );
const wxString printfDouble( const double &d );

// rounds a double to int
int a_rund( const double &v );

// whether len is between to deg values
int between( const double &len, const double &min, const double &max );  

// Calculate the time for a given JD (0..24)
double getTimeFromJD( const double &jd );

// Calculate the distance between 2 points
double planetDistance( const double &len1, const double &len2 );

// return the number of days for a given month and an given year, including leap years
int calcMonthLength( int monat, int jahr );

// workaroud for problems around the decimal point in different languages ( "." or ",")
double myatof( const wxString& );

// get number of years, etc for dasa length
void getDasaDuration( wxString&, double length );
void getDasaDurationInts( int &year, int &month, int &day, double length );

double getYearLength( const bool vedic );

/**************************************************************
***
**  Basic astrological funtions
***
***************************************************************/
// get the rasi for a given length (0..11)
int getRasi( const double &len );

// get the length in a specific rasi - reverse will be counted from the end (0..30)
double getRasiLen( const double &len, const bool &reverse = false );

// get the opposite point
double getOpposition( const double& );

// whether len is in odd, even or odd footed rasi
int isOddRasi( const double &len );
int isEvenRasi( const double &len );
int isOddFootedRasi( const int &rasi );

// get the varna of a length
int getVarna( const double &len );

// whether len is in ascendant, kona, kendra resp. to ascendant length
int inAscendant( const double &len, const double &asc );
int inTrikona( const double &len, const double &asc );
int inKendra( const double &len, const double &asc );

// whether len is in movable, fixed or dual sign
int inMovableSign( const double &len );
int inFixedSign( const double &len );
int inDualSign( const double &len );

// get the lord of a rasi (without nodes, otherwise use JaiminiExpert)
int getLord( const int &planet );

// Get the rasi where planet is exalted
int getExaltationRasi( const int &planet );

// whether planet is exalted or debilated in rasi
bool hasExaltationRasi( const int &planet, const int &rasi );
bool hasDebilationRasi( const int &planet, const int &rasi );

// return the mulatrikona rasi for planet
int getMulatrikonaRasi( const int &planet );

// whether planet with len is in mulatrikona (only for valid deg length)
bool isInMulatrikona( const int &planet, const double &len );

// The same if only the rasi is known
bool hasMulatrikonaRasi( const int &planet, const int &rasi );

// if 2 planets are naisargika or tatkalika mitra
int isFriend( const int &planet1, const int &planet2 );
int isRasiPosTempFriend( const int &rasi1, const int &rasi2 );

// Calculate sputa drishti of 2 planets with a given length
double getAspectValue( const int &planet1, const double &len1, const int &planet2, const double &len2 );

// Name of the avastha ( Sayana, Upavesana, etc.)
const wxChar *getAvasthaName( const int &i , const int &avastha = 0 );

/**************************************************************
***
**  Jaimini and Nakshatras
***
***************************************************************/
// get the length of a planet in his nakshatra (nsys = N27|N28)
double getNakshatraLength( const double &len, const int nsys );

// get the nakshatra of a planet with given length (nsys = N27|N28)
int getNakshatra( const double &len, const int nsys );

// number of pada for a given length
int getPada( const double &len );

// whether 2 rasi positions have a rasi drishti
bool hasJaiminiAspect( const int &pos1, const int &pos2 );

// whether 2 rasis are vishama of sama pada
bool isVishamapadaRasi( const int &rasi );
bool isSampadaRasi( const int &rasi );

double getNavamsaPortion( const double &len, const int &pindex, const bool &retro = false );


/**************************************************************
***
**  Western astrology
***
***************************************************************/
// whether 2 planets have o midpoint event
int berechneNGradTreffer( const double &len1, const double &len2, const int &maxorbis, double &orbis,
	const int gradkreis = GRADKREIS_45 );

double calcGeometricalMidpoint( const double &len1, const double &len2 );

// Number of degrees for a given gradkreis constant
double getKreisgrad( const int &gradkreis );

#endif


