/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           jyotish.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#include <wx/app.h>
#include <wx/cmdline.h>
#include <wx/config.h>
#include <wx/log.h>
#include <wx/string.h>

#include "Ashtakavarga.h"
#include "Conf.h"
#include "config.h"
#include "Dasa.h"
#include "Eclipse.h"
#include "Ephemeris.h"
#include "func.h"
#include "Hora.h"
#include "Horoscope.h"
#include "Jaimini.h"
#include "Lang.h"
#include "Midpoint.h"
#include "Nakshatra.h"
#include "Pair.h"
#include "PrintoutHelper.h"
#include "Session.h"
#include "TextHelper.h"
#include "Varga.h"
#include "ViewBuilder.h"
#include "VimsottariDasa.h"
#include "Writer.h"
#include "WriterFactory.h"

Horoscope *h, *g;
Config *config;
Writer *writer;

/**************************************************************
***
** showVedicPlanets
***
***************************************************************/
void showVedicPlanets()
{
	h->writeVedicPlanets( writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showKp
***
***************************************************************/
void showKP()
{
	h->writeKp( writer, 2 );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showNakshatras
***
***************************************************************/
void showNakshatras()
{
	VargaView view( h, 0 );
	NakshatraExpert expert( &view );
	expert.write( writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
**  showWesternPlanets
***
***************************************************************/
void showWesternPlanets()
{
	h->writeWesternPlanets( writer );
	Cout( writer->getContents() );
	printEl();
}


/**************************************************************
***
**  showAspects
***
***************************************************************/
void showAspects()
{
	h->writeAspects( writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showDasa
***
***************************************************************/
void showDasa( int dasa )
{
	Session *session = Session::get();
	assert( dasa < session->getNoOfDasaExperts());

	//session->getDasaExpert( dasa )->write( writer, h );
	session->getDasaExpert( dasa )->writeMore( writer, h );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** doSave
***
***************************************************************/
void doSave( const wxChar *filename )
{
	wxString s;
	if (! h->saveAs( filename ) ) { printErr( "Cannot save file" ); }
}

/**************************************************************
***
** showVargas
***
***************************************************************/
void showVargas()
{
	VargaExpert( h ).write( writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showBaseData
***
***************************************************************/
void showBaseData()
{
	TextHelper().writeBaseData( h, writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showPrintoutSummary
***
***************************************************************/
void showPrintoutSummary( const int &i )
{
	PrintoutHelper ph( h, writer );
	ph.writePrintoutSummary( i );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showAshtakavarga
***
***************************************************************/
void showAshtakavarga()
{
	VargaView view( h, 0 );
	AshtakavargaExpert expert( &view );
	expert.update();
	expert.write( writer );
	Cout( writer->getContents() );
	printEl();
}


/**************************************************************
***
** showJaimini
***
***************************************************************/
void showJaimini()
{
	VargaView view( h, 0 );
	JaiminiExpert expert( &view );
	expert.update();
	expert.write( writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showAvasthas
***
***************************************************************/
void showAvasthas()
{
	wxString s;
	h->dumpAvasthas( s );
	Cout( s );
	printEl();
}

/**************************************************************
***
** showBhavas
***
***************************************************************/
void showBhavas()
{
	h->writeBhavas( writer, true );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showTransits
***
***************************************************************/
void showTransits( int day, int month, int year )
{
	DataSet *dataset;
	dataset = new DataSet( *h->getDataSet() );
	if ( day * month * year != 0 ) dataset->setDate( day, month, year, 0 );
	else dataset->setActualDate();
	MidpointExpert( config->hsSystem ).writeTransitAnalysis( writer, h->getDataSet(), dataset, 30, 3, 0 );
	Cout( writer->getContents() );
	delete dataset;
}

/**************************************************************
***
** showMidpoints
***
***************************************************************/
void showMidpoints()
{
	MidpointExpert( config->hsSystem ).writeRadixAnalysis( writer, h, 90 ); //, GRADKREIS_225 );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showMidpoints
***
***************************************************************/
void showChains()
{
	MidpointExpert( config->hsSystem ).writeChainAnalysis( writer, h, 30, 4, 0, 1 );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showYearlyPreview
***
***************************************************************/
void showYearlyPreview( int year )
{
	if ( !year ) { printf( "Error: year not set, use option -Y" ); exit(1 ); }
	MidpointExpert( config->hsSystem ).writeYearlyPreviewAnalysis( writer, h->getDataSet(), 365.25, GRADKREIS_45, year );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showSolarArc
***
***************************************************************/
void showSolarArc( int day, int month, int year )
{
	DataSet *dataset;
	dataset = new DataSet( *h->getDataSet() );
	if ( day * month * year != 0 ) dataset->setDate( day, month, year, 0 );
	else dataset->setActualDate();
	MidpointExpert( config->hsSystem ).writeDirectionAnalysis( writer, h->getDataSet(), dataset, 365.25, 30, 3, 0, -1 );
	//MidpointExpert( config->hsSystem ).writeSolarArcAnalysis( writer, h->getDataSet(), dataset, 365.25, 30, 3, 0, -1 );
	Cout( writer->getContents() );
	delete dataset;
	printEl();
}

/**************************************************************
***
** listPlanets
***
***************************************************************/
void listPlanets()
{
	TextHelper th;
	th.listPlanets( h, writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
** showAstronomicalData
***
***************************************************************/
void showAstronomicalData()
{
	h->writeAstronomicalData( writer );
	Cout( writer->getContents() );
	printEl();
}

/**************************************************************
***
**   showTajaka
***
***************************************************************/
void showTajaka( int tajakayear )
{
	wxString s;
	TajakaHoroscope th( h->getDataSet() );
	th.calcTajaka( tajakayear, false );
	th.update();
	th.dump( s, false );
	Cout( s );
	printEl();
}

/**************************************************************
***
**   showPartnerAnalysis
***
***************************************************************/
void showPartnerAnalysis()
{
	Pair pair( h, g );
	pair.update();
	pair.write( writer );
	Cout( writer->getContents() );
	printEl();
}


class JyotishApp : public wxApp
{
public:

protected:
	virtual bool OnInit();
};

//IMPLEMENT_APP( JyotishApp )
IMPLEMENT_APP_CONSOLE( JyotishApp )

#include<wx/filefn.h>
/********************************************
***
**  Main
***
*********************************************/
//#include <Calculator.h>
bool JyotishApp::OnInit()
{
	long day = 0, month = 0, year = 0, dasa, style;
	wxString s;

	SetAppName( APP_NAME );
	SetVendorName( VENDOR_NAME );

	Session *session = Session::get();
	session->init( argv[0] );
	/*
	//TODO
	Calculator *calc = session->getCalculator();
	double lon = 9.71667167;
	double lat = 52.36667167;
	//double asc = 285.7291667;
	double asc = 309.0835555;
	double target = 248.1783333;
	double jd = 2438387.90141;
	calc->calcMcFromAsc( asc, jd, lon, lat );

	printf ( "Fertig\n" );
	return 0;
*/


	static const wxCmdLineEntryDesc cmdLineDesc[] =
	{
			{ wxCMD_LINE_SWITCH, wxT("h"), wxT("help"), wxT("show this help message"),
					wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP },
			{ wxCMD_LINE_OPTION, wxT("f"), wxT("file"), wxT("open file"), wxCMD_LINE_VAL_STRING },
			{ wxCMD_LINE_OPTION, wxT("s"), wxT("saveas"), wxT("save file as"), wxCMD_LINE_VAL_STRING },
			{ wxCMD_LINE_SWITCH, wxT("x"), wxT("tech"),   wxT("print tech output") },
			{ wxCMD_LINE_SWITCH, wxT("v"), wxT("vedic"),   wxT("show vedic planets") },
			{ wxCMD_LINE_SWITCH, wxT("w"), wxT("western"),   wxT("show western planets") },
			{ wxCMD_LINE_SWITCH, wxT("b"), wxT("base"),   wxT("show base data of chart") },
			{ wxCMD_LINE_SWITCH, wxT("B"), wxT("bhava"),   wxT("show bhavas") },
			{ wxCMD_LINE_SWITCH, wxT("k"), wxT("krishnamurti"),   wxT("show krishnamurti paksha") },
			{ wxCMD_LINE_SWITCH, wxT("n"), wxT("nakshatra"),   wxT("show nakshatras") },
			{ wxCMD_LINE_SWITCH, wxT("m"), wxT("midpoint"),   wxT("show midoints") },
			{ wxCMD_LINE_SWITCH, wxT("c"), wxT("chains"),   wxT("show chains (midpoint astrology)") },
			{ wxCMD_LINE_SWITCH, wxT("A"), wxT("aspect"),   wxT("show aspects (sphuta drishti)") },
			{ wxCMD_LINE_SWITCH, wxT("j"), wxT("jaimini"),   wxT("show jaimini stuff") },
			{ wxCMD_LINE_SWITCH, wxT("V"), wxT("varga"),   wxT("show vargas") },
			{ wxCMD_LINE_SWITCH, wxT("a"), wxT("ashtakavarga"),   wxT("show ashtakavarga") },
			{ wxCMD_LINE_SWITCH, wxT("y"), wxT("yoga"),   wxT("show yogas") },
			{ wxCMD_LINE_SWITCH, wxT("S"), wxT("astronomical"),   wxT("show astronomical data") },
			{ wxCMD_LINE_SWITCH, wxT("z"), wxT("avastha"),   wxT("show avasthas") },
			{ wxCMD_LINE_SWITCH, wxT("t"), wxT("transit"),   wxT("show transits") },
			{ wxCMD_LINE_SWITCH, wxT("e"), wxT("ephemeris"),   wxT("show ephemeris") },
			{ wxCMD_LINE_SWITCH, wxT("E"), wxT("eclipse"),   wxT("show eclipses") },
			{ wxCMD_LINE_SWITCH, wxT("H"), wxT("hora"),   wxT("show hora") },
			{ wxCMD_LINE_SWITCH, wxT("o"), wxT("solararc"),   wxT("show solar arc (midpoint astrology)") },
			{ wxCMD_LINE_SWITCH, wxT("P"), wxT("yearlypreview"),   wxT("show yearly preview (midpoint astrology)") },
			{ wxCMD_LINE_SWITCH, wxT("l"), wxT("list"),   wxT("list planets (like in main window)") },
			{ wxCMD_LINE_OPTION, wxT("g"), wxT("file2"), wxT("open second file (partner)"), wxCMD_LINE_VAL_STRING },

			{ wxCMD_LINE_OPTION, wxT("d"), wxT("dasa"), wxT("show dasa nb #n"), wxCMD_LINE_VAL_NUMBER },
			{ wxCMD_LINE_OPTION, wxT("Y"), wxT("year"), wxT("use specific year"), wxCMD_LINE_VAL_NUMBER },
			{ wxCMD_LINE_OPTION, wxT("p"), wxT("printsummary"), wxT("show printout summary"), wxCMD_LINE_VAL_NUMBER },
			{ wxCMD_LINE_OPTION, wxT("M"), wxT("month"), wxT("use specific month"), wxCMD_LINE_VAL_NUMBER },
			{ wxCMD_LINE_OPTION, wxT("D"), wxT("day"), wxT("use specific day"), wxCMD_LINE_VAL_NUMBER },

			{ wxCMD_LINE_NONE }
	};

	wxCmdLineParser parser(cmdLineDesc, argc, argv);
	int k = parser.Parse( true );
	if ( k != 0 )
	{
		//parser.Usage();
		//printNl();
		printEl();
		exit(1);
	}
	writer = WriterFactory().getWriter( WRITER_TEXT );

	parser.Found( wxT( "Y" ), &year  );
	parser.Found( wxT( "M" ), &month  );
	parser.Found( wxT( "D" ), &day  );
	if ( parser.Found( wxT( "e" ) ))
	{
		EphemExpert e;
		e.setPreferVedic( config->preferVedic );
		//e.prepareMonth( month, year, 1 );
		e.prepareMonth( 1, year, 1 );
		//e.writeIngress( writer, 1 );
		//e.writeKp( writer, 2 );
		//e.writeLunar( writer );
		//e.writeDetails( writer );
		e.writeDefaultEphemeris( writer, 1 );
		Cout( writer->getContents() );
		printEl();
	}
	else if ( parser.Found( wxT( "H" ) ))
	{
		DataSet dataset;
		if ( day * month * year != 0 ) dataset.setDate( day, month, year, 0 );
		//dataset.setDate( 25, 11, 2004, 7 );
		dataset.setLocation( config->defaultLocation );
		HoraExpert expert( &dataset );
		expert.update( dataset.getJD());
		//expert.dump( s, true );
		expert.write( writer, true );
		Cout( writer->getContents() );
		Cout( s );
		printEl();
	}
	else if ( parser.Found( wxT( "E" ) ))
	{
		double jd = JDate().getJD();
		EclipseExpert ec;
		ec.update( jd, jd + 365 * 3, 0, 0, true );
		ec.write( writer );
		Cout( writer->getContents() );
		printEl();
	}
	else
	{
		h = new Horoscope();
		if ( parser.Found( wxT( "f" ), &s  ))
		{
			if ( ! h->openFile( s ))
			{
				printErr( "ERROR: could not open chart" );
				exit(1);
			}
		}
		h->update();
		if ( parser.Found( wxT( "g" ), &s ))
		{
			g = new Horoscope();
			if ( ! g->openFile( s ))
			{
				printErr( "ERROR: could not open chart" );
				exit(1);
			}
			g->update();
			showPartnerAnalysis();
		}
		if ( parser.Found( wxT( "b" ) )) showBaseData();
		if ( parser.Found( wxT( "w" ) )) showWesternPlanets();
		if ( parser.Found( wxT( "v" ) )) showVedicPlanets();
		if ( parser.Found( wxT( "B" ) ) ) showBhavas();
		if ( parser.Found( wxT( "k" ) ) ) showKP();
		if ( parser.Found( wxT( "n" ) ) ) showNakshatras();
		if ( parser.Found( wxT( "m" ) ) ) showMidpoints();
		if ( parser.Found( wxT( "c" ) ) ) showChains();
		if ( parser.Found( wxT( "A" ) ) ) showAspects();
		if ( parser.Found( wxT( "l" ) ) ) listPlanets();

		if ( parser.Found( wxT( "j" ) ) ) showJaimini();
		if ( parser.Found( wxT( "V" ) ) ) showVargas();
		if ( parser.Found( wxT( "a" ) ) ) showAshtakavarga();
		if ( parser.Found( wxT( "p" ), &style ) ) showPrintoutSummary( style );
		if ( parser.Found( wxT( "S" ) ) ) showAstronomicalData();
		if ( parser.Found( wxT( "z" ) ) ) showAvasthas();
		if ( parser.Found( wxT( "t" ) ) ) showTransits( day, month, year);
		if ( parser.Found( wxT( "J" ) ) ) showTajaka( year );

		if ( parser.Found( wxT( "o" ) ) ) showSolarArc( day, month, year);
		if ( parser.Found( wxT( "P" ) ) ) showYearlyPreview( year );
		if ( parser.Found( wxT( "d" ), &dasa ) ) showDasa( dasa );
		if ( parser.Found( wxT( "s" ), &s ) ) doSave( s );

	}
	//config->writeAll();
	delete config;
	delete h;
	delete writer;
	return 0;
}


